/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class MacIntelliJTextFieldUI
extends TextFieldWithPopupHandlerUI {
    public MacIntelliJTextFieldUI(JTextField textField) {
        super(textField);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJTextFieldUI((JTextField)c);
    }

    @Override
    public void showSearchPopup() {
        Object value = this.myTextField.getClientProperty("JTextField.Search.FindPopup");
        JTextComponent editor = this.getComponent();
        if (editor != null && value instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)value;
            popup.show(editor, this.getSearchIconCoord().x, editor.getHeight());
        }
    }

    private boolean hasText() {
        JTextComponent component = this.getComponent();
        return component != null && !StringUtil.isEmpty((String)component.getText());
    }

    @Override
    public TextFieldWithPopupHandlerUI.SearchAction getActionUnder(MouseEvent e) {
        int off = JBUI.scale((int)8);
        Point point = new Point(e.getX() - off, e.getY() - off);
        return point.distance(this.getSearchIconCoord()) <= (double)off ? TextFieldWithPopupHandlerUI.SearchAction.POPUP : (this.hasText() && point.distance(this.getClearIconCoord()) <= (double)off ? TextFieldWithPopupHandlerUI.SearchAction.CLEAR : null);
    }

    protected Rectangle getDrawingRect() {
        return new Rectangle(0, (this.myTextField.getHeight() - 26) / 2, this.myTextField.getWidth(), this.myTextField.getHeight());
    }

    protected Point getSearchIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + JBUI.scale((int)3), r.y + (r.height - JBUI.scale((int)16)) / 2 + JBUI.scale((int)1));
    }

    protected Point getClearIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + r.width - JBUI.scale((int)16) - JBUI.scale((int)2), r.y + (r.height - JBUI.scale((int)16)) / 2);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        Rectangle r = this.getDrawingRect();
        if (c.isOpaque() && parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if (MacIntelliJTextFieldUI.isSearchField(c)) {
            this.paintSearchField(g, c, r);
        } else if (c.getBorder() instanceof MacIntelliJTextBorder) {
            g.setColor(c.getBackground());
            g.fillRect(3, 3, c.getWidth() - 6, c.getHeight() - 6);
        } else {
            super.paintBackground(g);
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        Dimension dimension = new Dimension(size.width, Math.max(26, size.height));
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/intellij/MacIntelliJTextFieldUI", "getPreferredSize"));
        }
        return dimension;
    }

    protected void paintSearchField(Graphics2D g, JTextComponent c, Rectangle r) {
        boolean noBorder = c.getClientProperty("JTextField.Search.noBorderRing") == Boolean.TRUE;
        boolean hasFocus = c.hasFocus() && !noBorder;
        Icon left = MacIntelliJIconCache.getIcon("searchFieldLeft", false, hasFocus);
        Icon middle = MacIntelliJIconCache.getIcon("searchFieldMiddle", false, hasFocus);
        Icon right = MacIntelliJIconCache.getIcon("searchFieldRight", false, hasFocus);
        Graphics gg = g.create(0, 0, c.getWidth(), c.getHeight());
        gg.setClip(r.x, r.y, r.width - right.getIconWidth(), r.height);
        int x = r.x;
        int stop2 = r.x + (r.width - right.getIconWidth());
        left.paintIcon(c, g, r.x, r.y);
        x += left.getIconWidth();
        while (x < stop2) {
            middle.paintIcon(c, gg, x, r.y);
            x += middle.getIconWidth();
        }
        gg.dispose();
        right.paintIcon(c, g, stop2, r.y);
        boolean withHistoryPopup = MacIntelliJTextFieldUI.isSearchFieldWithHistoryPopup(c);
        Icon label = MacIntelliJIconCache.getIcon(withHistoryPopup ? "searchFieldWithHistory" : "searchFieldLabel");
        if (StringUtil.isEmpty((String)c.getText()) && !c.hasFocus() && !withHistoryPopup) {
            label.paintIcon(c, g, r.x + (r.width - label.getIconWidth()) / 2, r.y);
        } else {
            gg = g.create(0, 0, c.getWidth(), c.getHeight());
            int offset = withHistoryPopup ? 5 : 8;
            gg.setClip(r.x + offset, r.y, StringUtil.isEmpty((String)c.getText()) ? label.getIconWidth() : 16, label.getIconHeight());
            label.paintIcon(c, gg, r.x + offset, r.y);
        }
        if (!StringUtil.isEmpty((String)c.getText())) {
            Icon clear = MacIntelliJIconCache.getIcon("searchFieldClear");
            clear.paintIcon(c, g, r.x + r.width - clear.getIconWidth() - 6, r.y);
        }
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rect = super.getVisibleEditorRect();
        if (rect != null) {
            if (MacIntelliJTextFieldUI.isSearchField(this.myTextField)) {
                rect.width -= 36;
                rect.x += 19;
                ++rect.y;
            } else {
                rect.x += 2;
                rect.width -= 4;
            }
        }
        return rect;
    }

    @Override
    protected void paintSafely(Graphics g) {
        this.paintBackground(g);
        super.paintSafely(g);
    }
}

