/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.AddSupportForFrameworksPanel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SupportForFrameworksStep
extends ModuleWizardStep {
    private final AddSupportForFrameworksPanel mySupportForFrameworksPanel;
    private final FrameworkSupportModelBase myFrameworkSupportModel;
    private final WizardContext myContext;
    private final ModuleBuilder myBuilder;
    private final ModuleBuilder.ModuleConfigurationUpdater myConfigurationUpdater;
    private boolean myCommitted;

    public SupportForFrameworksStep(WizardContext context, ModuleBuilder builder, @NotNull LibrariesContainer librariesContainer) {
        if (librariesContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "librariesContainer", "com/intellij/ide/util/newProjectWizard/SupportForFrameworksStep", "<init>"));
        }
        this.myContext = context;
        this.myBuilder = builder;
        List<FrameworkSupportInModuleProvider> providers = FrameworkSupportUtil.getProviders(builder);
        this.myFrameworkSupportModel = new FrameworkSupportModelInWizard(librariesContainer, builder);
        this.mySupportForFrameworksPanel = new AddSupportForFrameworksPanel(providers, this.myFrameworkSupportModel, false, null);
        this.myConfigurationUpdater = new ModuleBuilder.ModuleConfigurationUpdater(){

            public void update(@NotNull Module module2, @NotNull ModifiableRootModel rootModel) {
                if (module2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/util/newProjectWizard/SupportForFrameworksStep$1", "update"));
                }
                if (rootModel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/ide/util/newProjectWizard/SupportForFrameworksStep$1", "update"));
                }
                SupportForFrameworksStep.this.mySupportForFrameworksPanel.addSupport(module2, rootModel);
            }
        };
        builder.addModuleConfigurationUpdater(this.myConfigurationUpdater);
    }

    private static String getBaseDirectory(ModuleBuilder builder) {
        String path = builder.getContentEntryPath();
        return path != null ? FileUtil.toSystemIndependentName((String)path) : "";
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.mySupportForFrameworksPanel);
        super.disposeUIResources();
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.technologies";
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        if (finishChosen && !this.myCommitted) {
            if (!this.mySupportForFrameworksPanel.validate()) {
                throw new CommitStepException(null);
            }
            if (!this.mySupportForFrameworksPanel.downloadLibraries(this.mySupportForFrameworksPanel.getMainPanel())) {
                throw new CommitStepException(null);
            }
            this.myCommitted = true;
        }
    }

    public void onWizardFinished() throws CommitStepException {
        this._commit(true);
    }

    public JComponent getComponent() {
        return this.mySupportForFrameworksPanel.getMainPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySupportForFrameworksPanel.getFrameworksTree();
    }

    public void updateStep() {
        ProjectBuilder builder = this.myContext.getProjectBuilder();
        if (builder instanceof ModuleBuilder) {
            this.myBuilder.updateFrom((ModuleBuilder)builder);
            ((ModuleBuilder)builder).addModuleConfigurationUpdater(this.myConfigurationUpdater);
        }
        this.myFrameworkSupportModel.fireWizardStepUpdated();
    }

    public void updateDataModel() {
    }

    public String getName() {
        return "Add Frameworks";
    }

    private static class FrameworkSupportModelInWizard
    extends FrameworkSupportModelBase {
        private final ModuleBuilder myBuilder;

        public FrameworkSupportModelInWizard(LibrariesContainer librariesContainer, ModuleBuilder builder) {
            super(librariesContainer.getProject(), builder, librariesContainer);
            this.myBuilder = builder;
        }

        @Override
        @NotNull
        public String getBaseDirectoryForLibrariesPath() {
            String string = SupportForFrameworksStep.getBaseDirectory(this.myBuilder);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/SupportForFrameworksStep$FrameworkSupportModelInWizard", "getBaseDirectoryForLibrariesPath"));
            }
            return string;
        }
    }
}

