/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.configurable;

import com.intellij.internal.statistic.configurable.StatisticsConfigurationComponent;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private boolean modifiedByDefault;
    private StatisticsConfigurationComponent myConfig;

    public StatisticsConfigurable() {
        this(false);
    }

    public StatisticsConfigurable(boolean isModifiedByDefault) {
        this.modifiedByDefault = isModifiedByDefault;
    }

    @Nls
    public String getDisplayName() {
        return "Usage Statistics";
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "preferences.usage.statictics";
    }

    public JComponent createComponent() {
        this.myConfig = new StatisticsConfigurationComponent();
        return this.myConfig.getJComponent();
    }

    public boolean isModified() {
        UsageStatisticsPersistenceComponent persistenceComponent = UsageStatisticsPersistenceComponent.getInstance();
        return this.myConfig.isAllowed() != persistenceComponent.isAllowed() || this.myConfig.getPeriod() != persistenceComponent.getPeriod() || this.modifiedByDefault;
    }

    public void apply() throws ConfigurationException {
        UsageStatisticsPersistenceComponent persistenceComponent = UsageStatisticsPersistenceComponent.getInstance();
        persistenceComponent.setPeriod(this.myConfig.getPeriod());
        persistenceComponent.setAllowed(this.myConfig.isAllowed());
        persistenceComponent.setShowNotification(false);
        this.modifiedByDefault = false;
    }

    public void reset() {
        this.myConfig.reset();
    }

    public void disposeUIResources() {
        this.myConfig = null;
    }

    @NotNull
    public String getId() {
        if ("usage.statistics" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/configurable/StatisticsConfigurable", "getId"));
        }
        return "usage.statistics";
    }

    public Runnable enableSearch(String option) {
        return null;
    }
}

