/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.generic;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePersistentState {
    public static DataExternalizer<VirtualFilePersistentState> EXTERNALIZER = new VirtualFileStateExternalizer();
    private final long mySourceTimestamp;

    public VirtualFilePersistentState(long sourceTimestamp) {
        this.mySourceTimestamp = sourceTimestamp;
    }

    public final long getSourceTimestamp() {
        return this.mySourceTimestamp;
    }

    private static class VirtualFileStateExternalizer
    implements DataExternalizer<VirtualFilePersistentState> {
        private VirtualFileStateExternalizer() {
        }

        public void save(@NotNull DataOutput out, VirtualFilePersistentState value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/openapi/compiler/generic/VirtualFilePersistentState$VirtualFileStateExternalizer", "save"));
            }
            out.writeLong(value.getSourceTimestamp());
        }

        public VirtualFilePersistentState read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/openapi/compiler/generic/VirtualFilePersistentState$VirtualFileStateExternalizer", "read"));
            }
            return new VirtualFilePersistentState(in.readLong());
        }
    }
}

