/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.MergeConflict;
import com.intellij.openapi.diff.impl.incrementalMerge.TwoSideChange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

class ConflictChange
extends TwoSideChange.SideChange<MergeConflict> {
    private static final Logger LOG = Logger.getInstance(ConflictChange.class);
    private boolean mySemiApplied;

    public ConflictChange(@NotNull MergeConflict conflict, @NotNull FragmentSide mergeSide, @NotNull TextRange versionRange, @NotNull ChangeList changeList) {
        if (conflict == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflict", "com/intellij/openapi/diff/impl/incrementalMerge/ConflictChange", "<init>"));
        }
        if (mergeSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeSide", "com/intellij/openapi/diff/impl/incrementalMerge/ConflictChange", "<init>"));
        }
        if (versionRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionRange", "com/intellij/openapi/diff/impl/incrementalMerge/ConflictChange", "<init>"));
        }
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/diff/impl/incrementalMerge/ConflictChange", "<init>"));
        }
        super(conflict, changeList, ChangeType.CONFLICT, mergeSide, versionRange);
    }

    @Override
    public void onApplied() {
        this.markApplied();
        if (!this.mySemiApplied) {
            ConflictChange otherChange = ((MergeConflict)this.myTwoSideChange).getOtherChange(this);
            LOG.assertTrue(otherChange != null, (Object)String.format("Other change is null. This change: %s Merge conflict: %s", this, this.myTwoSideChange));
            otherChange.mySemiApplied = true;
            otherChange.updateOtherSideOnConflictApply();
            ((MergeConflict)this.myTwoSideChange).removeOtherChange(this);
        }
    }

    private void updateOtherSideOnConflictApply() {
        if (this.myOriginalSide.getStart() == this.myOriginalSide.getEnd()) {
            this.markApplied();
            return;
        }
        int startOffset = ((MergeConflict)this.myTwoSideChange).getRange().getEndOffset();
        TextRange emptyRange = new TextRange(startOffset, startOffset);
        ConflictChange leftChange = ConflictChange.isBranch(this.myOriginalSide.getFragmentSide()) ? null : this;
        ConflictChange rightChange = ConflictChange.isBranch(this.myOriginalSide.getFragmentSide()) ? this : null;
        this.myTwoSideChange = ((MergeConflict)this.myTwoSideChange).deriveSideForNotAppliedChange(emptyRange, leftChange, rightChange);
        this.myOriginalSide.getHighlighterHolder().updateHighlighter(this.myOriginalSide, this.myType);
        ((MergeConflict)this.myTwoSideChange).getHighlighterHolder().updateHighlighter(this.myTwoSideChange, this.myType);
        this.myChangeList.fireOnChangeApplied();
    }
}

