/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import org.jetbrains.annotations.Nullable;

public class PageDownWithSelectionAction
extends EditorAction {
    public PageDownWithSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    public static class Handler
    extends EditorActionHandler {
        public void doExecute(final Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (!editor.getCaretModel().supportsMultipleCarets()) {
                EditorActionUtil.moveCaretPageDown(editor, true);
                return;
            }
            if (editor.isColumnMode()) {
                int lines = editor.getScrollingModel().getVisibleArea().height / editor.getLineHeight();
                Caret currentCaret = caret == null ? editor.getCaretModel().getPrimaryCaret() : caret;
                for (int i = 0; i < lines && EditorActionUtil.cloneOrRemoveCaret(editor, currentCaret, false); ++i) {
                    currentCaret = editor.getCaretModel().getPrimaryCaret();
                }
            } else if (caret == null) {
                editor.getCaretModel().runForEachCaret(new CaretAction(){

                    public void perform(Caret caret) {
                        EditorActionUtil.moveCaretPageDown(editor, true);
                    }
                });
            } else {
                EditorActionUtil.moveCaretPageDown(editor, true);
            }
        }
    }
}

