/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemJdkUtil {
    @NonNls
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    @NonNls
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    @NonNls
    public static final String USE_JAVA_HOME = "#JAVA_HOME";

    @Nullable
    public static Sdk getJdk(@Nullable Project project2, @Nullable String jdkName) throws ExternalSystemJdkException {
        if (jdkName == null) {
            return null;
        }
        if (USE_INTERNAL_JAVA.equals(jdkName)) {
            return JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        }
        if (USE_PROJECT_JDK.equals(jdkName)) {
            if (project2 != null) {
                Module[] modules;
                Sdk res = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
                if (res != null) {
                    return res;
                }
                for (Module module2 : modules = ModuleManager.getInstance((Project)project2).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance((Module)module2).getSdk();
                    if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                    return sdk;
                }
            }
            if (project2 == null) {
                Sdk recent = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)JavaSdk.getInstance());
                if (recent != null) {
                    return recent;
                }
                return JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            }
            throw new ProjectJdkNotFoundException();
        }
        if (USE_JAVA_HOME.equals(jdkName)) {
            String javaHome = System.getenv("JAVA_HOME");
            if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
                throw new UndefinedJavaHomeException();
            }
            if (JdkUtil.checkForJdk((File)new File(javaHome)) || JdkUtil.checkForJre((String)javaHome)) {
                Sdk jdk = JavaSdk.getInstance().createJdk("", javaHome);
                if (jdk == null) {
                    throw new InvalidJavaHomeException(javaHome);
                }
                return jdk;
            }
            throw new InvalidJavaHomeException(javaHome);
        }
        for (Sdk projectJdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!projectJdk.getName().equals(jdkName)) continue;
            if (projectJdk.getHomePath() != null && (JdkUtil.checkForJdk((File)new File(projectJdk.getHomePath())) || JdkUtil.checkForJre((String)projectJdk.getHomePath()))) {
                return projectJdk;
            }
            throw new InvalidSdkException(projectJdk.getHomePath());
        }
        return null;
    }

    @Nullable
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project2) throws ExternalSystemJdkException {
        Sdk sdk;
        String javaHome;
        if (project2 != null) {
            Module[] modules;
            Sdk res = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
            if (res != null) {
                return Pair.create((Object)USE_PROJECT_JDK, (Object)res);
            }
            Module[] moduleArray = modules = ModuleManager.getInstance((Project)project2).getModules();
            int n = moduleArray.length;
            for (int i = 0; i < n; ++i) {
                Module module2 = moduleArray[i];
                Sdk sdk2 = ModuleRootManager.getInstance((Module)module2).getSdk();
                if (sdk2 == null || !(sdk2.getSdkType() instanceof JavaSdkType)) continue;
                return Pair.create((Object)USE_PROJECT_JDK, (Object)sdk2);
            }
        }
        if (!StringUtil.isEmptyOrSpaces((String)(javaHome = System.getenv("JAVA_HOME"))) && (JdkUtil.checkForJdk((File)new File(javaHome)) || JdkUtil.checkForJre((String)javaHome)) && (sdk = JavaSdk.getInstance().createJdk("", javaHome)) != null) {
            return Pair.create((Object)USE_JAVA_HOME, (Object)sdk);
        }
        for (Sdk projectJdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (projectJdk.getHomePath() == null || !JdkUtil.checkForJdk((File)new File(projectJdk.getHomePath())) && !JdkUtil.checkForJre((String)projectJdk.getHomePath())) continue;
            return Pair.create((Object)projectJdk.getName(), (Object)projectJdk);
        }
        Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        if (internalJdk != null) {
            return Pair.create((Object)USE_INTERNAL_JAVA, (Object)internalJdk);
        }
        return null;
    }

    public static boolean checkForJdk(@NotNull Project project2, @Nullable String jdkName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil", "checkForJdk"));
        }
        try {
            Sdk sdk = ExternalSystemJdkUtil.getJdk(project2, jdkName);
            return sdk != null && sdk.getHomePath() != null && JdkUtil.checkForJdk((File)new File(sdk.getHomePath()));
        }
        catch (ExternalSystemJdkException externalSystemJdkException) {
            return false;
        }
    }
}

