/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.service.task.AbstractToolWindowService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483644)
public class ToolWindowTaskService
extends AbstractToolWindowService<TaskData> {
    @NotNull
    public static final Function<DataNode<TaskData>, ExternalTaskPojo> MAPPER = new Function<DataNode<TaskData>, ExternalTaskPojo>(){

        public ExternalTaskPojo fun(DataNode<TaskData> node) {
            return ExternalTaskPojo.from((TaskData)((TaskData)node.getData()));
        }
    };
    public static final NullableFunction<DataNode<TaskData>, ExternalConfigPathAware> TASK_HOLDER_RETRIEVAL_STRATEGY = new NullableFunction<DataNode<TaskData>, ExternalConfigPathAware>(){

        @Nullable
        public ExternalConfigPathAware fun(DataNode<TaskData> node) {
            ModuleData moduleData = (ModuleData)node.getData(ProjectKeys.MODULE);
            return moduleData == null ? (ExternalConfigPathAware)node.getData(ProjectKeys.PROJECT) : moduleData;
        }
    };

    @NotNull
    public Key<TaskData> getTargetDataKey() {
        Key key = ProjectKeys.TASK;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ToolWindowTaskService", "getTargetDataKey"));
        }
        return key;
    }

    @Override
    protected void processData(@NotNull Collection<DataNode<TaskData>> nodes, @NotNull Project project2) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/task/ToolWindowTaskService", "processData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/task/ToolWindowTaskService", "processData"));
        }
        if (nodes.isEmpty()) {
            return;
        }
        ProjectSystemId externalSystemId = ((TaskData)nodes.iterator().next().getData()).getOwner();
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        ExternalSystemKeymapExtension.updateActions(project2, nodes);
        MultiMap grouped = ContainerUtil.groupBy(nodes, TASK_HOLDER_RETRIEVAL_STRATEGY);
        HashMap data = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : grouped.entrySet()) {
            data.put(((ExternalConfigPathAware)entry.getKey()).getLinkedExternalProjectPath(), ContainerUtilRt.map2List((Collection)((Collection)entry.getValue()), MAPPER));
        }
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project2);
        HashMap availableTasks = ContainerUtilRt.newHashMap((Map)settings.getAvailableTasks());
        availableTasks.putAll(data);
        settings.setAvailableTasks((Map)availableTasks);
    }
}

