/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.actions.SynchronizeAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.FileSystemTreeFactory;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.project.Project;

public class FileSystemTreeFactoryImpl
implements FileSystemTreeFactory {
    public FileSystemTree createFileSystemTree(Project project2, FileChooserDescriptor fileChooserDescriptor) {
        return new FileSystemTreeImpl(project2, fileChooserDescriptor);
    }

    public DefaultActionGroup createDefaultFileSystemActions(FileSystemTree fileSystemTree) {
        DefaultActionGroup group = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        group.add(actionManager.getAction("FileChooser.GotoHome"));
        group.add(actionManager.getAction("FileChooser.GotoProject"));
        group.addSeparator();
        group.add(actionManager.getAction("FileChooser.NewFolder"));
        group.add(actionManager.getAction("FileChooser.Delete"));
        group.addSeparator();
        SynchronizeAction action1 = new SynchronizeAction();
        AnAction original = actionManager.getAction("Synchronize");
        action1.copyFrom(original);
        action1.registerCustomShortcutSet(original.getShortcutSet(), fileSystemTree.getTree());
        group.add((AnAction)action1);
        group.addSeparator();
        group.add(actionManager.getAction("FileChooser.ShowHiddens"));
        return group;
    }
}

