/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.roots.IconActionComponent;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class JavaResourceRootEditHandlerBase
extends ModuleSourceRootEditHandler<JavaResourceRootProperties> {
    public JavaResourceRootEditHandlerBase(JpsModuleSourceRootType<JavaResourceRootProperties> rootType) {
        super(rootType);
    }

    @Override
    @Nullable
    public Icon getFolderUnderRootIcon() {
        return null;
    }

    @Override
    @Nullable
    public CustomShortcutSet getMarkRootShortcutSet() {
        return null;
    }

    @Override
    @NotNull
    public Icon getRootIcon(@NotNull JavaResourceRootProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase", "getRootIcon"));
        }
        Icon icon = properties.isForGeneratedSources() ? this.getGeneratedRootIcon() : this.getRootIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase", "getRootIcon"));
        }
        return icon;
    }

    @NotNull
    protected Icon getGeneratedRootIcon() {
        Icon icon = this.getRootIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase", "getGeneratedRootIcon"));
        }
        return icon;
    }

    @Override
    @Nullable
    public String getPropertiesString(@NotNull JavaResourceRootProperties properties) {
        String relativeOutputPath;
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase", "getPropertiesString"));
        }
        StringBuilder buffer = new StringBuilder();
        if (properties.isForGeneratedSources()) {
            buffer.append(" [generated]");
        }
        if (!(relativeOutputPath = properties.getRelativeOutputPath()).isEmpty()) {
            buffer.append(" (").append(relativeOutputPath).append(")");
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    @Override
    @Nullable
    public JComponent createPropertiesEditor(final @NotNull SourceFolder folder, final @NotNull JComponent parentComponent, final @NotNull ContentRootPanel.ActionCallback callback) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase", "createPropertiesEditor"));
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase", "createPropertiesEditor"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase", "createPropertiesEditor"));
        }
        IconActionComponent iconComponent = new IconActionComponent(AllIcons.Modules.SetPackagePrefix, AllIcons.Modules.SetPackagePrefixRollover, ProjectBundle.message((String)"module.paths.edit.properties.tooltip", (Object[])new Object[0]), new Runnable(){

            @Override
            public void run() {
                JavaResourceRootProperties properties = (JavaResourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.RESOURCES);
                assert (properties != null);
                ResourceRootPropertiesDialog dialog = new ResourceRootPropertiesDialog(parentComponent, properties);
                if (dialog.showAndGet()) {
                    callback.onSourceRootPropertiesChanged(folder);
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)iconComponent, "Center");
        panel.add(Box.createHorizontalStrut(3), "East");
        return panel;
    }

    private static class ResourceRootPropertiesDialog
    extends DialogWrapper {
        private final JTextField myRelativeOutputPathField;
        private final JCheckBox myIsGeneratedCheckBox;
        private final JPanel myMainPanel;
        @NotNull
        private final JavaResourceRootProperties myProperties;

        private ResourceRootPropertiesDialog(@NotNull JComponent parentComponent, @NotNull JavaResourceRootProperties properties) {
            if (parentComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase$ResourceRootPropertiesDialog", "<init>"));
            }
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase$ResourceRootPropertiesDialog", "<init>"));
            }
            super((Component)parentComponent, true);
            this.myProperties = properties;
            this.setTitle(ProjectBundle.message((String)"module.paths.edit.properties.title", (Object[])new Object[0]));
            this.myRelativeOutputPathField = new JTextField();
            this.myIsGeneratedCheckBox = new JCheckBox(UIUtil.replaceMnemonicAmpersand((String)"For &generated resources"));
            this.myMainPanel = FormBuilder.createFormBuilder().addLabeledComponent("Relative output &path:", (JComponent)this.myRelativeOutputPathField).addComponent((JComponent)this.myIsGeneratedCheckBox).getPanel();
            this.myRelativeOutputPathField.setText(this.myProperties.getRelativeOutputPath());
            this.myRelativeOutputPathField.setColumns(25);
            this.myIsGeneratedCheckBox.setSelected(this.myProperties.isForGeneratedSources());
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myRelativeOutputPathField;
        }

        protected void doOKAction() {
            this.myProperties.setRelativeOutputPath(ResourceRootPropertiesDialog.normalizePath(this.myRelativeOutputPathField.getText()));
            this.myProperties.setForGeneratedSources(this.myIsGeneratedCheckBox.isSelected());
            super.doOKAction();
        }

        @NotNull
        private static String normalizePath(String path) {
            String string = StringUtil.trimEnd((String)StringUtil.trimStart((String)FileUtil.toSystemIndependentName((String)path.trim()), (String)"/"), (String)"/");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JavaResourceRootEditHandlerBase$ResourceRootPropertiesDialog", "normalizePath"));
            }
            return string;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myMainPanel;
        }
    }
}

