/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.updateSettings.impl.ButtonInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.util.BuildNumber;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00192\u0006\u0010#\u001a\u00020\u0006J\b\u0010$\u001a\u0004\u0018\u00010\u0019J\b\u0010%\u001a\u00020\u0013H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "", "node", "Lorg/jdom/Element;", "(Lorg/jdom/Element;)V", "apiVersion", "Lcom/intellij/openapi/util/BuildNumber;", "getApiVersion", "()Lcom/intellij/openapi/util/BuildNumber;", "buttons", "", "Lcom/intellij/openapi/updateSettings/impl/ButtonInfo;", "getButtons", "()Ljava/util/List;", "majorVersion", "", "getMajorVersion", "()I", "message", "", "getMessage", "()Ljava/lang/String;", "number", "getNumber", "patches", "Lcom/intellij/openapi/updateSettings/impl/PatchInfo;", "releaseDate", "Ljava/util/Date;", "getReleaseDate", "()Ljava/util/Date;", "version", "getVersion", "compareTo", "other", "findPatchForBuild", "currentBuild", "findPatchForCurrentBuild", "toString", "platform-impl"})
public final class BuildInfo
implements Comparable<BuildInfo> {
    @NotNull
    private final BuildNumber number;
    @NotNull
    private final BuildNumber apiVersion;
    @NotNull
    private final String version;
    @NotNull
    private final String message;
    @Nullable
    private final Date releaseDate;
    @NotNull
    private final List<ButtonInfo> buttons;
    private final List<PatchInfo> patches;

    @NotNull
    public final BuildNumber getNumber() {
        return this.number;
    }

    @NotNull
    public final BuildNumber getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final Date getReleaseDate() {
        return this.releaseDate;
    }

    @NotNull
    public final List<ButtonInfo> getButtons() {
        return this.buttons;
    }

    public final int getMajorVersion() {
        int dotIndex = StringsKt.indexOf$default((CharSequence)this.version, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dotIndex > 0) {
            try {
                String $receiver$iv;
                String string = this.version;
                int startIndex$iv = 0;
                void v0 = $receiver$iv;
                if (v0 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)v0).substring(startIndex$iv, dotIndex);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $receiver$iv = string2;
                return Integer.parseInt($receiver$iv);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Nullable
    public final PatchInfo findPatchForCurrentBuild() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        return this.findPatchForBuild(buildNumber);
    }

    @Nullable
    public final PatchInfo findPatchForBuild(@NotNull BuildNumber currentBuild) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)currentBuild, (String)"currentBuild");
            Iterable $receiver$iv = this.patches;
            Iterable $receiver$iv$iv = $receiver$iv;
            for (Object element$iv$iv : $receiver$iv$iv) {
                PatchInfo it = (PatchInfo)element$iv$iv;
                if (!(it.isAvailable() && Intrinsics.areEqual((Object)it.getFromBuild().asStringWithoutProductCode(), (Object)currentBuild.asStringWithoutProductCode()))) continue;
                v0 = element$iv$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    public int compareTo(@NotNull BuildInfo other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.number.compareTo(other.number);
    }

    @NotNull
    public String toString() {
        return "BuildInfo(number=" + this.number + ")";
    }

    public BuildInfo(@NotNull Element node) {
        Object object;
        Element it;
        Collection destination$iv$iv;
        Object item$iv$iv;
        Object $receiver$iv$iv;
        Date date;
        Object $i$a$1;
        Object object2;
        String string;
        Object object3;
        Object it2;
        Object $receiver$iv;
        BuildInfo buildInfo;
        block14: {
            Object object4;
            BuildInfo buildInfo2;
            block13: {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                String string2 = node.getAttributeValue("number");
                if (string2 == null) {
                    throw (Throwable)new JDOMException("build.number missing");
                }
                BuildNumber buildNumber = BuildNumber.fromString((String)string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"BuildNumber.fromString(n\u2026(\"build.number missing\"))");
                this.number = buildNumber;
                buildInfo2 = this;
                object4 = node.getAttributeValue("apiVersion");
                if (object4 == null) break block13;
                String string3 = object4;
                buildInfo = buildInfo2;
                it2 = (String)$receiver$iv;
                object3 = BuildNumber.fromString((String)it2, (String)this.number.getProductCode());
                buildInfo2 = buildInfo;
                object4 = object3;
                if (object4 != null) break block14;
            }
            object4 = buildInfo2.apiVersion = this.number;
        }
        if ((string = node.getAttributeValue("version")) == null) {
            string = this.version = "";
        }
        if ((object2 = node.getChild("message")) == null || (object2 = object2.getValue()) == null) {
            object2 = "";
        }
        this.message = object2;
        BuildInfo buildInfo3 = this;
        String string4 = node.getAttributeValue("releaseDate");
        if (string4 != null) {
            $receiver$iv = string4;
            buildInfo = buildInfo3;
            it2 = $receiver$iv;
            try {
                $i$a$1 = new SimpleDateFormat("yyyyMMdd", Locale.US).parse((String)it2);
            }
            catch (ParseException e) {
                Logger.getInstance(BuildInfo.class).info("Failed to parse build release date " + (String)it2);
                $i$a$1 = null;
            }
            object3 = $i$a$1;
            buildInfo3 = buildInfo;
            date = (Date)object3;
        } else {
            date = null;
        }
        buildInfo3.releaseDate = date;
        $receiver$iv = node.getChildren("button");
        buildInfo = this;
        it2 = $receiver$iv;
        $i$a$1 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            Element $i$f$let = (Element)item$iv$iv;
            object3 = destination$iv$iv;
            void v9 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
            object = new ButtonInfo((Element)v9);
            object3.add(object);
        }
        buildInfo.buttons = object3 = (List)destination$iv$iv;
        $receiver$iv = node.getChildren("patch");
        buildInfo = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (Element)item$iv$iv;
            object3 = destination$iv$iv;
            Element element = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"it");
            object = new PatchInfo(element);
            object3.add(object);
        }
        buildInfo.patches = object3 = (List)destination$iv$iv;
    }
}

