/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import java.awt.Font;
import java.util.List;

public class IssueLinkHtmlRenderer {
    private IssueLinkHtmlRenderer() {
    }

    public static String formatTextIntoHtml(Project project2, String c) {
        return "<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()) + "</head><body>" + IssueLinkHtmlRenderer.formatTextWithLinks(project2, c) + "</body></html>";
    }

    public static String formatTextWithLinks(Project project2, String c, Convertor<String, String> convertor) {
        if (c == null) {
            return "";
        }
        String comment = XmlTagUtilBase.escapeString((String)c, (boolean)false);
        StringBuilder commentBuilder = new StringBuilder();
        IssueNavigationConfiguration config = IssueNavigationConfiguration.getInstance((Project)project2);
        List list = config.findIssueLinks((CharSequence)comment);
        int pos = 0;
        for (IssueNavigationConfiguration.LinkMatch match : list) {
            TextRange range = match.getRange();
            commentBuilder.append((String)convertor.convert((Object)comment.substring(pos, range.getStartOffset()))).append("<a href=\"").append(match.getTargetUrl()).append("\">");
            commentBuilder.append(range.substring(comment)).append("</a>");
            pos = range.getEndOffset();
        }
        commentBuilder.append((String)convertor.convert((Object)comment.substring(pos)));
        comment = commentBuilder.toString();
        return comment.replace("\n", "<br>");
    }

    public static String formatTextWithLinks(Project project2, String c) {
        return IssueLinkHtmlRenderer.formatTextWithLinks(project2, c, (Convertor<String, String>)Convertor.SELF);
    }
}

