/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class ImportIntoShelfAction
extends DumbAwareAction {
    public ImportIntoShelfAction() {
        super("Import Patches...", "Copies a patch file to the shelf", null);
    }

    public void update(AnActionEvent e) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        e.getPresentation().setEnabled(project2 != null);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null) {
            return;
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project2, null, (Consumer)new Consumer<List<VirtualFile>>(){

            public void consume(List<VirtualFile> files) {
                String message;
                int toImport;
                ShelveChangesManager shelveChangesManager;
                ArrayList patchTypeFiles;
                ProgressManager pm = ProgressManager.getInstance();
                boolean filesFound = pm.runProcessWithProgressSynchronously(new Runnable(patchTypeFiles = new ArrayList(), shelveChangesManager = ShelveChangesManager.getInstance(project2), files){
                    final /* synthetic */ List val$patchTypeFiles;
                    final /* synthetic */ ShelveChangesManager val$shelveChangesManager;
                    final /* synthetic */ List val$files;
                    {
                        this.val$patchTypeFiles = list;
                        this.val$shelveChangesManager = shelveChangesManager;
                        this.val$files = list2;
                    }

                    @Override
                    public void run() {
                        this.val$patchTypeFiles.addAll(this.val$shelveChangesManager.gatherPatchFiles(this.val$files));
                    }
                }, "Looking for patch files...", true, project2);
                if (!filesFound || patchTypeFiles.isEmpty()) {
                    return;
                }
                if (!patchTypeFiles.equals(files) && 1 == (toImport = Messages.showYesNoDialog((Project)project2, (String)(message = "Found " + (patchTypeFiles.size() == 1 ? "one patch file (" + ((VirtualFile)patchTypeFiles.get(0)).getPath() + ")." : patchTypeFiles.size() + " patch files.") + "\nContinue with import?"), (String)"Import Patches", (Icon)Messages.getQuestionIcon()))) {
                    return;
                }
                pm.runProcessWithProgressSynchronously(new Runnable(){

                    @Override
                    public void run() {
                        final ArrayList exceptions = new ArrayList();
                        List<ShelvedChangeList> lists = shelveChangesManager.importChangeLists(patchTypeFiles, new Consumer<VcsException>(){

                            public void consume(VcsException e) {
                                exceptions.add(e);
                            }
                        });
                        if (!lists.isEmpty()) {
                            ShelvedChangesViewManager.getInstance(project2).activateView(lists.get(lists.size() - 1));
                        }
                        if (!exceptions.isEmpty()) {
                            AbstractVcsHelper.getInstance((Project)project2).showErrors(exceptions, "Import patches into shelf");
                        }
                        if (lists.isEmpty() && exceptions.isEmpty()) {
                            VcsBalloonProblemNotifier.showOverChangesView(project2, "No patches found", MessageType.WARNING, new NamedRunnable[0]);
                        }
                    }
                }, "Import patches into shelf", true, project2);
            }
        });
    }
}

