/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import org.jetbrains.annotations.NotNull;

class IdentityVirtualFilePointer
implements VirtualFilePointer {
    private final VirtualFile myFile;
    private final String myUrl;

    IdentityVirtualFilePointer(VirtualFile file2, @NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer", "<init>"));
        }
        this.myFile = file2;
        this.myUrl = url;
    }

    @NotNull
    public String getFileName() {
        String string = this.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer", "getFileName"));
        }
        return string;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer", "getUrl"));
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = this.getUrl();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer", "getPresentableUrl"));
        }
        return string;
    }

    public boolean isValid() {
        return this.myFile == null || this.myFile.isValid();
    }
}

