/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.packageDependencies.actions.AnalyzeDependenciesOnSpecifiedTargetHandler;
import com.intellij.psi.search.GlobalSearchScope;

public class AnalyzeDependenciesOnSpecifiedTargetAction
extends AnAction {
    public static final DataKey<GlobalSearchScope> TARGET_SCOPE_KEY = DataKey.create((String)"MODULE_DEPENDENCIES_TARGET_SCOPE");

    public AnalyzeDependenciesOnSpecifiedTargetAction() {
        super("Analyze Dependencies on Specified Target");
    }

    public void actionPerformed(AnActionEvent e) {
        Module module2 = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        GlobalSearchScope targetScope = (GlobalSearchScope)e.getData(TARGET_SCOPE_KEY);
        if (module2 == null || targetScope == null) {
            return;
        }
        new AnalyzeDependenciesOnSpecifiedTargetHandler(module2.getProject(), new AnalysisScope(module2), targetScope).analyze();
    }

    public void update(AnActionEvent e) {
        Module module2 = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        GlobalSearchScope scope = (GlobalSearchScope)e.getData(TARGET_SCOPE_KEY);
        Presentation presentation = e.getPresentation();
        if (module2 != null && scope != null) {
            presentation.setVisible(true);
            presentation.setText("Analyze Dependencies of Module '" + module2.getName() + "' on " + scope.getDisplayName());
        } else {
            presentation.setVisible(false);
        }
    }
}

