/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.element;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.PositionElementFilter;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.reference.SoftReference;

public class ExcludeDeclaredFilter
extends PositionElementFilter {
    SoftReference<PsiElement> myCachedVar = new SoftReference(null);
    SoftReference<PsiElement> myCurrentContext = new SoftReference(null);

    public ExcludeDeclaredFilter(ElementFilter filter) {
        this.setFilter(filter);
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (this.myCurrentContext.get() != context) {
            PsiElement cachedVar;
            this.myCurrentContext = new SoftReference((Object)context);
            for (cachedVar = context; cachedVar != null && !this.getFilter().isAcceptable((Object)cachedVar, cachedVar.getContext()); cachedVar = cachedVar.getContext()) {
            }
            this.myCachedVar = new SoftReference((Object)cachedVar);
        }
        if (element instanceof PsiMethod && this.myCachedVar.get() instanceof PsiMethod) {
            PsiMethod currentMethod = (PsiMethod)element;
            PsiMethod candidate = (PsiMethod)this.myCachedVar.get();
            return !candidate.getManager().areElementsEquivalent((PsiElement)candidate, (PsiElement)currentMethod) && !ExcludeDeclaredFilter.isOverridingMethod(currentMethod, candidate);
        }
        if (element instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)element).resolve();
            return this.isAcceptable(psiClass, context);
        }
        if (context != null) {
            if (element instanceof PsiElement) {
                return !context.getManager().areElementsEquivalent((PsiElement)this.myCachedVar.get(), (PsiElement)element);
            }
            return true;
        }
        return true;
    }

    private static boolean isOverridingMethod(PsiMethod method, PsiMethod candidate) {
        if (method.getManager().areElementsEquivalent((PsiElement)method, (PsiElement)candidate)) {
            return false;
        }
        if (!MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)candidate)) {
            return false;
        }
        PsiClass candidateContainingClass = candidate.getContainingClass();
        return candidateContainingClass.isInheritor(method.getContainingClass(), true);
    }
}

