/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.xml;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnotherLanguageBlockWrapper
extends AbstractXmlBlock {
    private final InjectedLanguageBlockWrapper myInjectedBlock;
    private final Indent myIndent;

    public AnotherLanguageBlockWrapper(ASTNode node, XmlFormattingPolicy policy, Block original, Indent indent, int offset, @Nullable TextRange range) {
        super(node, original.getWrap(), original.getAlignment(), policy, false);
        this.myInjectedBlock = new InjectedLanguageBlockWrapper(original, offset, range, null);
        this.myIndent = indent;
    }

    @Override
    public Indent getIndent() {
        return this.myIndent;
    }

    @Override
    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    @Override
    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    @Override
    public boolean isTextElement() {
        return true;
    }

    @Override
    protected List<Block> buildChildren() {
        return this.myInjectedBlock.getSubBlocks();
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myInjectedBlock.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/xml/AnotherLanguageBlockWrapper", "getTextRange"));
        }
        return textRange;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/psi/formatter/xml/AnotherLanguageBlockWrapper", "getSpacing"));
        }
        return this.myInjectedBlock.getSpacing(child1, child2);
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = this.myInjectedBlock.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/xml/AnotherLanguageBlockWrapper", "getChildAttributes"));
        }
        return childAttributes;
    }
}

