/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.google.common.base.Objects;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.WeakInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnchorTypeInfo {
    private static final WeakInterner<AnchorTypeInfo> ourInterner = new WeakInterner();
    private final Class myElementClass;
    private final IElementType myElementType;
    private final Language myFileLanguage;

    private AnchorTypeInfo(Class elementClass, @Nullable IElementType elementType, Language fileLanguage) {
        this.myElementClass = elementClass;
        this.myElementType = elementType;
        this.myFileLanguage = fileLanguage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnchorTypeInfo)) {
            return false;
        }
        AnchorTypeInfo info = (AnchorTypeInfo)o;
        return this.myElementType == info.myElementType && this.myElementClass == info.myElementClass && this.myFileLanguage == info.myFileLanguage;
    }

    public int hashCode() {
        return (this.myElementType == null ? 0 : this.myElementType.hashCode() * 31 * 31) + 31 * this.myElementClass.getName().hashCode() + this.myFileLanguage.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("class", (Object)this.myElementClass).add("elementType", (Object)this.myElementType).add("fileLanguage", (Object)this.myFileLanguage).toString();
    }

    @NotNull
    public Language getFileLanguage() {
        Language language = this.myFileLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/AnchorTypeInfo", "getFileLanguage"));
        }
        return language;
    }

    public boolean isAcceptable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/AnchorTypeInfo", "isAcceptable"));
        }
        return this.myElementClass == element.getClass() && this.myElementType == PsiUtilCore.getElementType((PsiElement)element);
    }

    public static AnchorTypeInfo obtainInfo(@NotNull PsiElement element, @NotNull Language fileLanguage) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/smartPointers/AnchorTypeInfo", "obtainInfo"));
        }
        if (fileLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLanguage", "com/intellij/psi/impl/smartPointers/AnchorTypeInfo", "obtainInfo"));
        }
        return AnchorTypeInfo.obtainInfo(element.getClass(), PsiUtilCore.getElementType((PsiElement)element), fileLanguage);
    }

    @NotNull
    static AnchorTypeInfo obtainInfo(@NotNull Class elementClass, @Nullable IElementType elementType, @NotNull Language fileLanguage) {
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/psi/impl/smartPointers/AnchorTypeInfo", "obtainInfo"));
        }
        if (fileLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLanguage", "com/intellij/psi/impl/smartPointers/AnchorTypeInfo", "obtainInfo"));
        }
        AnchorTypeInfo anchorTypeInfo = (AnchorTypeInfo)ourInterner.intern((Object)new AnchorTypeInfo(elementClass, elementType, fileLanguage));
        if (anchorTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/AnchorTypeInfo", "obtainInfo"));
        }
        return anchorTypeInfo;
    }
}

