/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDocMethodOrFieldRef
extends CompositePsiElement
implements PsiDocTagValue,
Constants {
    public PsiDocMethodOrFieldRef() {
        super(DOC_METHOD_OR_FIELD_REF);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDocTagValue((PsiDocTagValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public PsiReference getReference() {
        PsiClass scope = this.getScope();
        PsiElement element = this.getNameElement();
        if (scope == null || element == null) {
            return new MyReference(null);
        }
        PsiReference psiReference = this.getReferenceInScope(scope, element);
        if (psiReference != null) {
            return psiReference;
        }
        PsiClass containingClass = scope.getContainingClass();
        while (containingClass != null) {
            PsiClass classScope = containingClass;
            psiReference = this.getReferenceInScope(classScope, element);
            if (psiReference != null) {
                return psiReference;
            }
            containingClass = classScope.getContainingClass();
        }
        return new MyReference(null);
    }

    @Nullable
    private PsiReference getReferenceInScope(PsiClass scope, PsiElement element) {
        PsiMethod[] methods;
        MethodSignature methodSignature;
        final String name = element.getText();
        String[] signature = this.getSignature();
        if (signature == null) {
            PsiVariable[] vars;
            for (PsiVariable var : vars = PsiDocMethodOrFieldRef.getAllVariables((PsiElement)scope, this)) {
                if (!var.getName().equals(name)) continue;
                return new MyReference((PsiElement)var);
            }
        }
        if (signature != null) {
            ArrayList types = ContainerUtil.newArrayListWithCapacity((int)signature.length);
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory();
            for (String s : signature) {
                try {
                    types.add(elementFactory.createTypeFromText(s, element));
                }
                catch (IncorrectOperationException e) {
                    types.add(PsiType.NULL);
                }
            }
            methodSignature = MethodSignatureUtil.createMethodSignature((String)name, (PsiType[])types.toArray(PsiType.createArray((int)types.size())), (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY, (boolean)name.equals(scope.getName()));
        } else {
            methodSignature = null;
        }
        for (PsiMethod method : methods = PsiDocMethodOrFieldRef.getAllMethods((PsiElement)scope, this)) {
            if (!method.getName().equals(name) || methodSignature != null && !MethodSignatureUtil.areSignaturesErasureEqual(methodSignature, (MethodSignature)method.getSignature(PsiSubstitutor.EMPTY))) continue;
            return new MyReference((PsiElement)method){

                @Override
                @NotNull
                public PsiElement[] getVariants() {
                    ArrayList<PsiMethod> lst = new ArrayList<PsiMethod>();
                    for (PsiMethod method : methods) {
                        if (!name.equals(method.getName())) continue;
                        lst.add(method);
                    }
                    PsiElement[] psiElementArray = (PsiElement[])lst.toArray(new PsiMethod[lst.size()]);
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$1", "getVariants"));
                    }
                    return psiElementArray;
                }
            };
        }
        return null;
    }

    public static PsiVariable[] getAllVariables(PsiElement scope, PsiElement place) {
        SmartList result = new SmartList();
        scope.processDeclarations(new FilterScopeProcessor((ElementFilter)ElementClassFilter.VARIABLE, result), ResolveState.initial(), null, place);
        return (PsiVariable[])result.toArray((Object[])new PsiVariable[result.size()]);
    }

    public static PsiMethod[] getAllMethods(PsiElement scope, PsiElement place) {
        SmartList result = new SmartList();
        scope.processDeclarations(new FilterScopeProcessor((ElementFilter)ElementClassFilter.METHOD, result), ResolveState.initial(), null, place);
        return (PsiMethod[])result.toArray((Object[])new PsiMethod[result.size()]);
    }

    @Override
    public int getTextOffset() {
        PsiElement element = this.getNameElement();
        return element != null ? element.getTextRange().getStartOffset() : this.getTextRange().getEndOffset();
    }

    @Nullable
    public PsiElement getNameElement() {
        ASTNode name = this.findChildByType(DOC_TAG_VALUE_TOKEN);
        return name != null ? (PsiElement)SourceTreeToPsiMap.treeToPsiNotNull(name) : null;
    }

    @Nullable
    public String[] getSignature() {
        PsiElement element = this.getNameElement();
        if (element == null) {
            return null;
        }
        for (element = element.getNextSibling(); element != null && !(element instanceof PsiDocTagValue); element = element.getNextSibling()) {
        }
        if (element == null) {
            return null;
        }
        ArrayList<String> types = new ArrayList<String>();
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            String[] typeStrings;
            if (child.getNode().getElementType() != DOC_TYPE_HOLDER) continue;
            for (String type : typeStrings = child.getText().split("[, ]")) {
                if (type.isEmpty()) continue;
                types.add(type);
            }
        }
        return ArrayUtil.toStringArray(types);
    }

    @Nullable
    private PsiClass getScope() {
        if (this.getFirstChildNode().getElementType() == JavaDocElementType.DOC_REFERENCE_HOLDER) {
            PsiElement firstChildPsi = SourceTreeToPsiMap.treeElementToPsi(this.getFirstChildNode().getFirstChildNode());
            if (firstChildPsi instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)firstChildPsi;
                PsiElement referencedElement = referenceElement.resolve();
                if (referencedElement instanceof PsiClass) {
                    return (PsiClass)referencedElement;
                }
                return null;
            }
            if (firstChildPsi instanceof PsiKeyword) {
                PsiKeyword keyword = (PsiKeyword)firstChildPsi;
                if (keyword.getTokenType().equals(THIS_KEYWORD)) {
                    return JavaResolveUtil.getContextClass(this);
                }
                if (keyword.getTokenType().equals(SUPER_KEYWORD)) {
                    PsiClass contextClass = JavaResolveUtil.getContextClass(this);
                    if (contextClass != null) {
                        return contextClass.getSuperClass();
                    }
                    return null;
                }
            }
        }
        return JavaResolveUtil.getContextClass(this);
    }

    public class MyReference
    implements PsiJavaReference {
        private final PsiElement myReferredElement;

        public MyReference(PsiElement referredElement) {
            this.myReferredElement = referredElement;
        }

        public PsiElement resolve() {
            return this.myReferredElement;
        }

        public void processVariants(@NotNull PsiScopeProcessor processor2) {
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference", "processVariants"));
            }
            for (PsiElement element : this.getVariants()) {
                if (processor2.execute(element, ResolveState.initial())) continue;
                return;
            }
        }

        @NotNull
        public JavaResolveResult advancedResolve(boolean incompleteCode) {
            Object object = this.myReferredElement == null ? JavaResolveResult.EMPTY : new CandidateInfo(this.myReferredElement, PsiSubstitutor.EMPTY);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference", "advancedResolve"));
            }
            return object;
        }

        @NotNull
        public JavaResolveResult[] multiResolve(boolean incompleteCode) {
            JavaResolveResult[] javaResolveResultArray;
            if (this.myReferredElement == null) {
                javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
            } else {
                JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                javaResolveResultArray = javaResolveResultArray2;
                javaResolveResultArray2[0] = new CandidateInfo(this.myReferredElement, PsiSubstitutor.EMPTY);
            }
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference", "multiResolve"));
            }
            return javaResolveResultArray;
        }

        @NotNull
        public PsiElement[] getVariants() {
            ArrayList vars = new ArrayList();
            for (PsiClass scope = PsiDocMethodOrFieldRef.this.getScope(); scope != null; scope = scope.getContainingClass()) {
                ContainerUtil.addAll(vars, (Object[])PsiDocMethodOrFieldRef.getAllMethods((PsiElement)scope, PsiDocMethodOrFieldRef.this));
                ContainerUtil.addAll(vars, (Object[])PsiDocMethodOrFieldRef.getAllVariables((PsiElement)scope, PsiDocMethodOrFieldRef.this));
            }
            PsiElement[] psiElementArray = (PsiElement[])vars.toArray(new PsiModifierListOwner[vars.size()]);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference", "getVariants"));
            }
            return psiElementArray;
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public String getCanonicalText() {
            PsiElement nameElement = PsiDocMethodOrFieldRef.this.getNameElement();
            assert (nameElement != null);
            String string = nameElement.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference", "getCanonicalText"));
            }
            return string;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            PsiElement nameElement = PsiDocMethodOrFieldRef.this.getNameElement();
            assert (nameElement != null);
            TreeElement treeElement = SourceTreeToPsiMap.psiToTreeNotNull(nameElement);
            CharTable charTableByTree = SharedImplUtil.findCharTableByTree(treeElement);
            LeafElement newToken = Factory.createSingleLeafElement(JavaDocTokenType.DOC_TAG_VALUE_TOKEN, newElementName, charTableByTree, PsiDocMethodOrFieldRef.this.getManager());
            ((CompositeElement)treeElement.getTreeParent()).replaceChildInternal(SourceTreeToPsiMap.psiToTreeNotNull(nameElement), newToken);
            return SourceTreeToPsiMap.treeToPsiNotNull(newToken);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String newName;
            PsiClass containingClass;
            boolean hasSignature;
            PsiMethod method;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/javadoc/PsiDocMethodOrFieldRef$MyReference", "bindToElement"));
            }
            if (this.isReferenceTo(element)) {
                return PsiDocMethodOrFieldRef.this;
            }
            PsiElement nameElement = PsiDocMethodOrFieldRef.this.getNameElement();
            assert (nameElement != null);
            String name = nameElement.getText();
            if (element instanceof PsiMethod) {
                method = (PsiMethod)element;
                hasSignature = PsiDocMethodOrFieldRef.this.getSignature() != null;
                containingClass = method.getContainingClass();
                newName = method.getName();
            } else if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                hasSignature = false;
                containingClass = field.getContainingClass();
                method = null;
                newName = field.getName();
            } else {
                throw new IncorrectOperationException();
            }
            PsiElement child = PsiDocMethodOrFieldRef.this.getFirstChild();
            if (containingClass != null && child != null && child.getNode().getElementType() == JavaDocElementType.DOC_REFERENCE_HOLDER) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)child.getFirstChild();
                assert (referenceElement != null);
                referenceElement.bindToElement((PsiElement)containingClass);
            } else if (containingClass != null && !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)PsiDocMethodOrFieldRef.this, (boolean)true)) {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)containingClass.getProject()).getElementFactory();
                PsiReferenceExpression ref = elementFactory.createReferenceExpression(containingClass);
                PsiDocMethodOrFieldRef.this.addAfter((PsiElement)ref, null);
            }
            if (hasSignature || !name.equals(newName)) {
                String text = PsiDocMethodOrFieldRef.this.getText();
                StringBuffer newText = new StringBuffer();
                newText.append("/** @see ");
                if (name.equals(newName)) {
                    newText.append(text.substring(0, text.indexOf(40)));
                } else {
                    int sharpIndex = text.indexOf(35);
                    if (sharpIndex >= 0) {
                        newText.append(text.substring(0, sharpIndex + 1));
                    }
                    newText.append(newName);
                }
                if (hasSignature) {
                    newText.append('(');
                    Object[] parameters = method.getParameterList().getParameters();
                    newText.append(StringUtil.join((Object[])parameters, (Function)new Function<PsiParameter, String>(){

                        public String fun(PsiParameter parameter) {
                            return TypeConversionUtil.erasure((PsiType)parameter.getType()).getCanonicalText();
                        }
                    }, (String)","));
                    newText.append(')');
                }
                newText.append("*/");
                return this.bindToText(containingClass, newText);
            }
            return PsiDocMethodOrFieldRef.this;
        }

        public PsiElement bindToText(PsiClass containingClass, StringBuffer newText) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)containingClass.getProject()).getElementFactory();
            PsiComment comment = elementFactory.createCommentFromText(newText.toString(), null);
            PsiElement tag = PsiTreeUtil.getChildOfType((PsiElement)comment, PsiDocTag.class);
            PsiElement ref = PsiTreeUtil.getChildOfType((PsiElement)tag, PsiDocMethodOrFieldRef.class);
            assert (ref != null) : newText;
            return PsiDocMethodOrFieldRef.this.replace(ref);
        }

        public boolean isReferenceTo(PsiElement element) {
            return PsiDocMethodOrFieldRef.this.getManager().areElementsEquivalent(this.resolve(), element);
        }

        public TextRange getRangeInElement() {
            ASTNode sharp = PsiDocMethodOrFieldRef.this.findChildByType(JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN);
            if (sharp == null) {
                return new TextRange(0, PsiDocMethodOrFieldRef.this.getTextLength());
            }
            PsiElement nextSibling = SourceTreeToPsiMap.treeToPsiNotNull(sharp).getNextSibling();
            if (nextSibling != null) {
                int startOffset = nextSibling.getTextRange().getStartOffset() - PsiDocMethodOrFieldRef.this.getTextRange().getStartOffset();
                int endOffset = nextSibling.getTextRange().getEndOffset() - PsiDocMethodOrFieldRef.this.getTextRange().getStartOffset();
                return new TextRange(startOffset, endOffset);
            }
            return new TextRange(PsiDocMethodOrFieldRef.this.getTextLength(), PsiDocMethodOrFieldRef.this.getTextLength());
        }

        public PsiElement getElement() {
            return PsiDocMethodOrFieldRef.this;
        }
    }
}

