/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.CompoundInitialState;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSessionContainer {
    private static final Logger LOG = Logger.getInstance((String)("#" + InferenceSessionContainer.class.getName()));
    private final Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    public void registerNestedSession(InferenceSession session) {
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.getInferenceSessionContainer().myNestedSessions);
    }

    @Contract(value="_, !null -> !null")
    public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType((PsiElement)arg, PsiCall.class));
        return session == null ? defaultSession : session.getInferenceSubstitution();
    }

    void registerNestedSession(InferenceSession session, PsiType returnType, PsiExpression returnExpression) {
        InferenceSession inferenceSession;
        PsiSubstitutor callSession = this.findNestedSubstitutor((PsiElement)((PsiCallExpression)returnExpression).getArgumentList(), null);
        if (callSession == null && (inferenceSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, returnExpression, returnType)) != null && inferenceSession != session) {
            this.registerNestedSession(inferenceSession);
        }
    }

    static PsiSubstitutor infer(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, final @NotNull PsiElement parent) {
        CompoundInitialState compoundInitialState;
        InitialInferenceState initialInferenceState;
        InferenceSession session;
        PsiCall topLevelCall;
        PsiExpressionList argumentList;
        MethodCandidateInfo.CurrentCandidateProperties properties;
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parent instanceof PsiCall && (properties = MethodCandidateInfo.getCurrentMethod((PsiElement)(argumentList = ((PsiCall)parent).getArgumentList()))) != null && !properties.isApplicabilityCheck() && (topLevelCall = (PsiCall)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)parent, false, (Computable)new Computable<PsiCall>(){

            public PsiCall compute() {
                if (parent instanceof PsiExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent)) {
                    return null;
                }
                return InferenceSessionContainer.treeWalkUp(parent);
            }
        })) != null && (session = MethodCandidateInfo.isOverloadCheck() || !PsiDiamondType.ourDiamondGuard.currentStack().isEmpty() ? InferenceSessionContainer.startTopLevelInference(topLevelCall) : (InferenceSession)CachedValuesManager.getCachedValue((PsiElement)topLevelCall, (CachedValueProvider)new CachedValueProvider<InferenceSession>(){

            @Nullable
            public CachedValueProvider.Result<InferenceSession> compute() {
                return new CachedValueProvider.Result((Object)InferenceSessionContainer.startTopLevelInference(topLevelCall), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        })) != null && (initialInferenceState = (compoundInitialState = InferenceSessionContainer.createState(session)).getInitialState((PsiCall)PsiTreeUtil.getParentOfType((PsiElement)argumentList, PsiCall.class))) != null) {
            InferenceSession childSession = new InferenceSession(initialInferenceState);
            List<String> errorMessages = session.getIncompatibleErrorMessages();
            if (errorMessages != null) {
                properties.getInfo().setInferenceError(StringUtil.join(errorMessages, (String)"\n"));
                return childSession.prepareSubstitution();
            }
            return childSession.collectAdditionalAndInfer(parameters, arguments, properties, compoundInitialState.getInitialSubstitutor());
        }
        InferenceSession inferenceSession = new InferenceSession(typeParameters, partialSubstitutor, parent.getManager(), parent);
        inferenceSession.initExpressionConstraints(parameters, arguments, parent, null);
        return inferenceSession.infer(parameters, arguments, parent);
    }

    private static CompoundInitialState createState(InferenceSession topLevelSession) {
        PsiSubstitutor topInferenceSubstitutor = InferenceSessionContainer.replaceVariables(topLevelSession.getInferenceVariables());
        final LinkedHashMap<PsiElement, InitialInferenceState> nestedStates = new LinkedHashMap<PsiElement, InitialInferenceState>();
        InferenceSessionContainer copy = new InferenceSessionContainer(){

            @Override
            public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
                InitialInferenceState state = (InitialInferenceState)nestedStates.get(PsiTreeUtil.getParentOfType((PsiElement)arg, PsiCall.class));
                if (state != null) {
                    return state.getInferenceSubstitutor();
                }
                return super.findNestedSubstitutor(arg, defaultSession);
            }
        };
        Map<PsiElement, InferenceSession> nestedSessions = topLevelSession.getInferenceSessionContainer().myNestedSessions;
        for (Map.Entry<PsiElement, InferenceSession> entry : nestedSessions.entrySet()) {
            nestedStates.put(entry.getKey(), entry.getValue().createInitialState(copy, topInferenceSubstitutor));
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : topLevelSession.getInferenceVariables()) {
            PsiClass psiClass;
            PsiType instantiation = variable.getInstantiation();
            if (instantiation == PsiType.NULL || !((psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)topInferenceSubstitutor.substitute((PsiTypeParameter)variable))) instanceof InferenceVariable)) continue;
            substitutor = substitutor.put((PsiTypeParameter)psiClass, instantiation);
        }
        return new CompoundInitialState(substitutor, nestedStates);
    }

    @Nullable
    private static InferenceSession startTopLevelInference(final PsiCall topLevelCall) {
        final JavaResolveResult result = topLevelCall.resolveMethodGenerics();
        if (result instanceof MethodCandidateInfo) {
            final PsiMethod method = ((MethodCandidateInfo)result).getElement();
            final PsiParameter[] topLevelParameters = method.getParameterList().getParameters();
            PsiExpressionList topLevelCallArgumentList = topLevelCall.getArgumentList();
            LOG.assertTrue(topLevelCallArgumentList != null, (Object)topLevelCall);
            final PsiExpression[] topLevelArguments = topLevelCallArgumentList.getExpressions();
            return (InferenceSession)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)topLevelCall, true, (Computable)new Computable<InferenceSession>(){

                public InferenceSession compute() {
                    InferenceSession topLevelSession = new InferenceSession(method.getTypeParameters(), ((MethodCandidateInfo)result).getSiteSubstitutor(), topLevelCall.getManager(), (PsiElement)topLevelCall);
                    topLevelSession.initExpressionConstraints(topLevelParameters, topLevelArguments, (PsiElement)topLevelCall, method, ((MethodCandidateInfo)result).isVarargs());
                    topLevelSession.infer(topLevelParameters, topLevelArguments, (PsiElement)topLevelCall, ((MethodCandidateInfo)result).createProperties());
                    return topLevelSession;
                }
            });
        }
        return null;
    }

    @NotNull
    private static PsiSubstitutor replaceVariables(Collection<InferenceVariable> inferenceVariables) {
        InferenceVariable[] oldVars;
        ArrayList<InferenceVariable> targetVars = new ArrayList<InferenceVariable>();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : oldVars = inferenceVariables.toArray(new InferenceVariable[inferenceVariables.size()])) {
            InferenceVariable newVariable = new InferenceVariable(variable.getCallContext(), variable.getParameter(), variable.getName());
            substitutor = substitutor.put((PsiTypeParameter)variable, (PsiType)JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType((PsiClass)newVariable));
            targetVars.add(newVariable);
            if (!variable.isThrownBound()) continue;
            newVariable.setThrownBound();
        }
        for (int i = 0; i < targetVars.size(); ++i) {
            InferenceVariable var = (InferenceVariable)((Object)targetVars.get(i));
            for (InferenceBound boundType : InferenceBound.values()) {
                for (PsiType bound : oldVars[i].getBounds(boundType)) {
                    var.addBound(substitutor.substitute(bound), boundType, null);
                }
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "replaceVariables"));
        }
        return psiSubstitutor;
    }

    @Nullable
    public static PsiCall treeWalkUp(PsiElement context) {
        PsiCall top = null;
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{PsiExpressionList.class, PsiLambdaExpression.class, PsiConditionalExpression.class, PsiCodeBlock.class, PsiCall.class});
        while (!(parent instanceof PsiCall)) {
            MethodCandidateInfo.CurrentCandidateProperties properties;
            PsiCall psiCall;
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class);
            if (parent instanceof PsiCodeBlock) {
                if (lambdaExpression == null) break;
                boolean inReturnExpressions = false;
                for (PsiExpression expression : LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression)) {
                    inReturnExpressions |= PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)context, (boolean)false);
                }
                if (!inReturnExpressions || LambdaUtil.getFunctionalTypeMap().containsKey(lambdaExpression)) break;
            }
            if (parent instanceof PsiConditionalExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent) || parent instanceof PsiLambdaExpression && LambdaUtil.getFunctionalTypeMap().containsKey(parent) || (psiCall = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCall.class)) == null || (properties = MethodCandidateInfo.getCurrentMethod((PsiElement)psiCall.getArgumentList())) != null && (properties.isApplicabilityCheck() || lambdaExpression != null && lambdaExpression.hasFormalParameterTypes()) || !((top = psiCall) instanceof PsiExpression) || !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)top)) break;
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent.getParent(), (Class[])new Class[]{PsiExpressionList.class, PsiLambdaExpression.class, PsiCodeBlock.class});
        }
        if (top == null) {
            return null;
        }
        PsiExpressionList argumentList = top.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        LOG.assertTrue(MethodCandidateInfo.getCurrentMethod((PsiElement)argumentList) == null);
        return top;
    }
}

