/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NullFileReferenceHelper
extends FileReferenceHelper {
    public static final NullFileReferenceHelper INSTANCE = new NullFileReferenceHelper();

    @Override
    public PsiFileSystemItem findRoot(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/NullFileReferenceHelper", "findRoot"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        VirtualFile contentRootForFile = index.getContentRootForFile(file2);
        return contentRootForFile != null ? PsiManager.getInstance((Project)project2).findDirectory(contentRootForFile) : null;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(final @NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/resolve/reference/impl/providers/NullFileReferenceHelper", "getRoots"));
        }
        List list = ContainerUtil.mapNotNull((Object[])ModuleRootManager.getInstance((Module)module2).getContentRoots(), (Function)new Function<VirtualFile, PsiFileSystemItem>(){

            public PsiFileSystemItem fun(VirtualFile virtualFile) {
                return PsiManager.getInstance((Project)module2.getProject()).findDirectory(virtualFile);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/NullFileReferenceHelper", "getRoots"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project2, @NotNull VirtualFile file2) {
        PsiFileSystemItem parent;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/NullFileReferenceHelper", "getContexts"));
        }
        PsiFileSystemItem item = this.getPsiFileSystemItem(project2, file2);
        if (item != null && (parent = item.getParent()) != null) {
            Set<PsiFileSystemItem> set = Collections.singleton(parent);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/NullFileReferenceHelper", "getContexts"));
            }
            return set;
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/NullFileReferenceHelper", "getContexts"));
        }
        return list;
    }

    @Override
    public boolean isMine(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/NullFileReferenceHelper", "isMine"));
        }
        return ProjectRootManager.getInstance((Project)project2).getFileIndex().isInContent(file2);
    }

    @Override
    public boolean isFallback() {
        return true;
    }
}

