/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.IntroduceFunctionalParameterAction;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class IntroduceFunctionalParameterHandler
extends IntroduceParameterHandler {
    @Override
    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/actions/IntroduceFunctionalParameterHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/actions/IntroduceFunctionalParameterHandler", "invoke"));
        }
        if (dataContext != null) {
            PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (file2 != null && editor != null && !this.introduceStrategy(project2, editor, file2, elements)) {
                IntroduceFunctionalParameterHandler.showErrorMessage(project2, editor);
            }
        }
    }

    @Override
    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/actions/IntroduceFunctionalParameterHandler", "invoke"));
        }
        ExtractMethodHandler.selectAndPass(project2, editor, file2, new Pass<PsiElement[]>(){

            public void pass(PsiElement[] elements) {
                if (!IntroduceFunctionalParameterHandler.this.introduceStrategy(project2, editor, file2, elements)) {
                    IntroduceFunctionalParameterHandler.showErrorMessage(project2, editor);
                }
            }
        });
    }

    private static void showErrorMessage(@NotNull Project project2, Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/actions/IntroduceFunctionalParameterHandler", "showErrorMessage"));
        }
        String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{IntroduceFunctionalParameterAction.REFACTORING_NAME}));
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)IntroduceFunctionalParameterAction.REFACTORING_NAME, (String)"refactoring.introduceParameter");
    }
}

