/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nullable;

public class RenameHandlerRegistry {
    public static final Key<Boolean> SELECT_ALL = Key.create((String)"rename.selectAll");
    private final Set<RenameHandler> myHandlers = new HashSet();
    private static final RenameHandlerRegistry INSTANCE = new RenameHandlerRegistry();
    private final PsiElementRenameHandler myDefaultElementRenameHandler = new PsiElementRenameHandler();

    public static RenameHandlerRegistry getInstance() {
        return INSTANCE;
    }

    private RenameHandlerRegistry() {
    }

    public boolean hasAvailableHandler(DataContext dataContext) {
        for (RenameHandler renameHandler : (RenameHandler[])Extensions.getExtensions((ExtensionPointName)RenameHandler.EP_NAME)) {
            if (!renameHandler.isAvailableOnDataContext(dataContext)) continue;
            return true;
        }
        for (RenameHandler renameHandler : this.myHandlers) {
            if (!renameHandler.isAvailableOnDataContext(dataContext)) continue;
            return true;
        }
        return this.myDefaultElementRenameHandler.isAvailableOnDataContext(dataContext);
    }

    @Nullable
    public RenameHandler getRenameHandler(DataContext dataContext) {
        TreeMap<String, RenameHandler> availableHandlers = new TreeMap<String, RenameHandler>();
        for (RenameHandler renameHandler : (RenameHandler[])Extensions.getExtensions((ExtensionPointName)RenameHandler.EP_NAME)) {
            if (!renameHandler.isRenaming(dataContext)) continue;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return renameHandler;
            }
            availableHandlers.put(RenameHandlerRegistry.getHandlerTitle(renameHandler), renameHandler);
        }
        for (RenameHandler renameHandler : this.myHandlers) {
            if (!renameHandler.isRenaming(dataContext)) continue;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return renameHandler;
            }
            availableHandlers.put(RenameHandlerRegistry.getHandlerTitle(renameHandler), renameHandler);
        }
        if (availableHandlers.size() == 1) {
            return (RenameHandler)availableHandlers.values().iterator().next();
        }
        Iterator iterator = availableHandlers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!(entry.getValue() instanceof MemberInplaceRenameHandler)) continue;
            iterator.remove();
            break;
        }
        if (availableHandlers.size() == 1) {
            return (RenameHandler)availableHandlers.values().iterator().next();
        }
        if (availableHandlers.size() > 1) {
            String[] strings = ArrayUtil.toStringArray(availableHandlers.keySet());
            HandlersChooser chooser = new HandlersChooser((Project)CommonDataKeys.PROJECT.getData(dataContext), strings);
            if (chooser.showAndGet()) {
                return (RenameHandler)availableHandlers.get(chooser.getSelection());
            }
            throw new ProcessCanceledException();
        }
        return this.myDefaultElementRenameHandler.isRenaming(dataContext) ? this.myDefaultElementRenameHandler : null;
    }

    private static String getHandlerTitle(RenameHandler renameHandler) {
        return renameHandler instanceof TitledHandler ? StringUtil.capitalize((String)((TitledHandler)renameHandler).getActionTitle().toLowerCase()) : renameHandler.toString();
    }

    public void registerHandler(RenameHandler handler2) {
        this.myHandlers.add(handler2);
    }

    private static class HandlersChooser
    extends DialogWrapper {
        private final String[] myRenamers;
        private String mySelection;
        private final JRadioButton[] myRButtons;

        protected HandlersChooser(Project project2, String[] renamers) {
            super(project2);
            this.myRenamers = renamers;
            this.myRButtons = new JRadioButton[this.myRenamers.length];
            this.mySelection = renamers[0];
            this.setTitle(RefactoringBundle.message((String)"select.refactoring.title"));
            this.init();
        }

        protected JComponent createNorthPanel() {
            JPanel radioPanel = new JPanel();
            radioPanel.setLayout(new BoxLayout(radioPanel, 1));
            JLabel descriptionLabel = new JLabel(RefactoringBundle.message((String)"what.would.you.like.to.do"));
            descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            radioPanel.add(descriptionLabel);
            ButtonGroup bg = new ButtonGroup();
            boolean selected = true;
            int rIdx = 0;
            for (final String renamer : this.myRenamers) {
                final JRadioButton rb = new JRadioButton(renamer, selected);
                this.myRButtons[rIdx++] = rb;
                ActionListener listener2 = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (rb.isSelected()) {
                            mySelection = renamer;
                        }
                    }
                };
                rb.addActionListener(listener2);
                selected = false;
                bg.add(rb);
                radioPanel.add(rb);
            }
            new RadioUpDownListener(this.myRButtons);
            return radioPanel;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myRButtons[0];
        }

        public String getSelection() {
            return this.mySelection;
        }

        protected JComponent createCenterPanel() {
            return null;
        }
    }
}

