/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook.deductive.builder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.typeCook.deductive.resolver.Binding;

public abstract class Constraint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.typeCook.deductive.builder.Constraint");
    PsiType myLeft;
    PsiType myRight;

    public Constraint(PsiType left, PsiType right) {
        LOG.assertTrue(left != null, (Object)"<null> left type");
        LOG.assertTrue(right != null, (Object)"<null> right type");
        this.myLeft = left;
        this.myRight = right;
    }

    public PsiType getRight() {
        return this.myRight;
    }

    public PsiType getLeft() {
        return this.myLeft;
    }

    abstract String relationString();

    abstract int relationType();

    public String toString() {
        return this.myLeft.getCanonicalText() + " " + this.relationString() + " " + this.myRight.getCanonicalText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Constraint)) {
            return false;
        }
        Constraint constraint = (Constraint)o;
        if (this.myLeft != null ? !this.myLeft.equals(constraint.myLeft) : constraint.myLeft != null) {
            return false;
        }
        return !(this.myRight != null ? !this.myRight.equals(constraint.myRight) : constraint.myRight != null);
    }

    public int hashCode() {
        int result = this.myLeft != null ? this.myLeft.hashCode() : 0;
        result = 29 * result + (this.myRight != null ? this.myRight.hashCode() : 0);
        return result + this.relationType();
    }

    public abstract Constraint apply(Binding var1);
}

