/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.annotation.AsyncCall;
import com.intellij.remoteServer.agent.annotation.ChildCall;
import com.intellij.remoteServer.agent.annotation.FinalCall;
import com.intellij.remoteServer.agent.annotation.ImmediateCall;
import com.intellij.remoteServer.agent.impl.ChildWrapperCreator;
import com.intellij.remoteServer.agent.impl.util.FinalTask;
import com.intellij.remoteServer.agent.impl.util.SequentialTaskExecutor;
import com.intellij.util.containers.HashMap;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Nullable;

public class ThreadInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + ThreadInvocationHandler.class.getName()));
    private final SequentialTaskExecutor myTaskExecutor;
    private final ClassLoader myCallerClassLoader;
    private final Object myTarget;
    private final ChildWrapperCreator myPreWrapperFactory;
    private Map<Object, Object> myChild2Wrapped;

    public ThreadInvocationHandler(SequentialTaskExecutor taskExecutor, ClassLoader callerClassLoader, Object target) {
        this(taskExecutor, callerClassLoader, target, null);
    }

    public ThreadInvocationHandler(SequentialTaskExecutor taskExecutor, ClassLoader callerClassLoader, Object target, @Nullable ChildWrapperCreator preWrapperCreator) {
        this.myTaskExecutor = taskExecutor;
        this.myCallerClassLoader = callerClassLoader;
        this.myTarget = target;
        this.myPreWrapperFactory = preWrapperCreator;
        this.myChild2Wrapped = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        boolean finalCall;
        Callable<Object> taskCallable;
        block21: {
            boolean finalCall2;
            boolean asyncCall;
            block20: {
                boolean finalCall3;
                boolean immediateCall;
                block17: {
                    boolean finalCall4;
                    Object object;
                    Object child;
                    block19: {
                        boolean finalCall5;
                        block18: {
                            boolean finalCall6;
                            boolean childCall;
                            taskCallable = new Callable<Object>(){

                                @Override
                                public Object call() {
                                    try {
                                        return method.invoke(ThreadInvocationHandler.this.myTarget, args);
                                    }
                                    catch (IllegalAccessException e) {
                                        LOG.error((Throwable)e);
                                        return null;
                                    }
                                    catch (InvocationTargetException e) {
                                        LOG.error((Throwable)e);
                                        return null;
                                    }
                                }
                            };
                            immediateCall = method.getAnnotation(ImmediateCall.class) != null;
                            boolean bl = childCall = method.getAnnotation(ChildCall.class) != null;
                            if (!childCall) break block17;
                            Object object2 = child = immediateCall ? taskCallable.call() : this.myTaskExecutor.queueAndWaitTask(taskCallable);
                            if (child != null) break block18;
                            Object var8_10 = null;
                            boolean bl2 = finalCall6 = method.getAnnotation(FinalCall.class) != null;
                            if (finalCall6) {
                                this.myTaskExecutor.queueTask(new FinalTask(){

                                    @Override
                                    public void run() {
                                    }
                                });
                            }
                            return var8_10;
                        }
                        Object cached = this.myChild2Wrapped.get(child);
                        if (cached == null) break block19;
                        Object finalCall6 = cached;
                        boolean bl = finalCall5 = method.getAnnotation(FinalCall.class) != null;
                        if (finalCall5) {
                            this.myTaskExecutor.queueTask(new /* invalid duplicate definition of identical inner class */);
                        }
                        return finalCall6;
                    }
                    try {
                        Object result;
                        Class<?> childClass = child.getClass();
                        if (childClass.isArray()) {
                            Class<?> componentType = childClass.getComponentType();
                            int length = Array.getLength(child);
                            result = Array.newInstance(componentType, length);
                            for (int i = 0; i < length; ++i) {
                                Array.set(result, i, this.createChildProxy(Array.get(child, i)));
                            }
                        } else {
                            result = this.createChildProxy(child);
                        }
                        this.myChild2Wrapped.put(child, result);
                        object = result;
                        boolean bl = finalCall4 = method.getAnnotation(FinalCall.class) != null;
                    }
                    catch (Throwable throwable) {
                        boolean finalCall7;
                        boolean bl = finalCall7 = method.getAnnotation(FinalCall.class) != null;
                        if (finalCall7) {
                            this.myTaskExecutor.queueTask(new /* invalid duplicate definition of identical inner class */);
                        }
                        throw throwable;
                    }
                    if (finalCall4) {
                        this.myTaskExecutor.queueTask(new /* invalid duplicate definition of identical inner class */);
                    }
                    return object;
                }
                if (!immediateCall && !StringUtil.equals((CharSequence)method.getName(), (CharSequence)"toString")) break block20;
                Object child = taskCallable.call();
                boolean bl = finalCall3 = method.getAnnotation(FinalCall.class) != null;
                if (finalCall3) {
                    this.myTaskExecutor.queueTask(new /* invalid duplicate definition of identical inner class */);
                }
                return child;
            }
            boolean bl = asyncCall = method.getAnnotation(AsyncCall.class) != null;
            if (!asyncCall) break block21;
            this.myTaskExecutor.queueTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        taskCallable.call();
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
            Object var8_13 = null;
            boolean bl3 = finalCall2 = method.getAnnotation(FinalCall.class) != null;
            if (finalCall2) {
                this.myTaskExecutor.queueTask(new /* invalid duplicate definition of identical inner class */);
            }
            return var8_13;
        }
        Object object = this.myTaskExecutor.queueAndWaitTask(taskCallable);
        boolean bl = finalCall = method.getAnnotation(FinalCall.class) != null;
        if (finalCall) {
            this.myTaskExecutor.queueTask(new /* invalid duplicate definition of identical inner class */);
        }
        return object;
    }

    private Object createChildProxy(Object child) {
        Class<?> callerChildInterface;
        Class<?> childClass = child.getClass();
        Class<?>[] childInterfaces = childClass.getInterfaces();
        LOG.assertTrue(childInterfaces.length == 1, (Object)"Child class is expected to implement single child interface");
        Class<?> childInterface = childInterfaces[0];
        try {
            callerChildInterface = this.myCallerClassLoader.loadClass(childInterface.getName());
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
            return null;
        }
        Object preWrappedChild = this.myPreWrapperFactory == null ? child : Proxy.newProxyInstance(this.myCallerClassLoader, new Class[]{callerChildInterface}, this.myPreWrapperFactory.createWrapperInvocationHandler(child));
        return Proxy.newProxyInstance(this.myCallerClassLoader, new Class[]{callerChildInterface}, (InvocationHandler)new ThreadInvocationHandler(this.myTaskExecutor, this.myCallerClassLoader, preWrappedChild, this.myPreWrapperFactory));
    }
}

