/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.ui.UIUtil;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;
import org.junit.Test;
import org.junit.runner.RunWith;
import sun.awt.AWTAutoShutdown;

public class TestRunnerUtil {
    private TestRunnerUtil() {
    }

    public static boolean isJUnit4TestClass(Class aClass) {
        int modifiers = aClass.getModifiers();
        if ((modifiers & 0x400) != 0) {
            return false;
        }
        if ((modifiers & 1) == 0) {
            return false;
        }
        if (aClass.getAnnotation(RunWith.class) != null) {
            return true;
        }
        for (Method method : aClass.getMethods()) {
            if (method.getAnnotation(Test.class) == null) continue;
            return true;
        }
        return false;
    }

    public static void replaceIdeEventQueueSafely() {
        if (Toolkit.getDefaultToolkit().getSystemEventQueue() instanceof IdeEventQueue) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("must not call under EDT");
        }
        AWTAutoShutdown.getInstance().notifyThreadBusy(Thread.currentThread());
        UIUtil.pump();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    IdeEventQueue.getInstance();
                }
            });
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

