/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.actions.BaseGenerateAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseGenerateTestSupportMethodAction
extends BaseGenerateAction {
    protected static final Logger LOG = Logger.getInstance((String)("#" + BaseGenerateTestSupportMethodAction.class.getName()));

    public BaseGenerateTestSupportMethodAction(TestIntegrationUtils.MethodKind methodKind) {
        super((CodeInsightActionHandler)new MyHandler(methodKind));
    }

    @Nullable
    public AnAction createEditTemplateAction(DataContext dataContext) {
        PsiClass targetClass;
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiClass psiClass = targetClass = editor == null || file2 == null ? null : this.getTargetClass(editor, file2);
        if (targetClass != null) {
            final List<TestFramework> frameworks = TestIntegrationUtils.findSuitableFrameworks(targetClass);
            final TestIntegrationUtils.MethodKind methodKind = ((MyHandler)this.getHandler()).myMethodKind;
            if (!frameworks.isEmpty()) {
                return new AnAction("Edit Template"){

                    public void actionPerformed(AnActionEvent e) {
                        BaseGenerateTestSupportMethodAction.chooseAndPerform(editor, frameworks, (Consumer<TestFramework>)((Consumer)new Consumer<TestFramework>(){

                            public void consume(TestFramework framework) {
                                FileTemplateDescriptor descriptor = methodKind.getFileTemplateDescriptor(framework);
                                if (descriptor != null) {
                                    String fileName = descriptor.getFileName();
                                    AllFileTemplatesConfigurable.editCodeTemplate(FileUtil.getNameWithoutExtension((String)fileName), project2);
                                } else {
                                    HintManager.getInstance().showErrorHint(editor, "No template found for " + framework.getName() + ":" + BaseGenerateTestSupportMethodAction.this.getTemplatePresentation().getText());
                                }
                            }
                        }));
                    }
                };
            }
        }
        return null;
    }

    protected PsiClass getTargetClass(Editor editor, PsiFile file2) {
        return BaseGenerateTestSupportMethodAction.findTargetClass(editor, file2);
    }

    @Nullable
    private static PsiClass findTargetClass(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testIntegration/BaseGenerateTestSupportMethodAction", "findTargetClass"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testIntegration/BaseGenerateTestSupportMethodAction", "findTargetClass"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false) == null ? null : TestIntegrationUtils.findOuterClass(element);
    }

    protected boolean isValidForClass(PsiClass targetClass) {
        List<TestFramework> frameworks = TestIntegrationUtils.findSuitableFrameworks(targetClass);
        if (frameworks.isEmpty()) {
            return false;
        }
        for (TestFramework each : frameworks) {
            if (!this.isValidFor(targetClass, each)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testIntegration/BaseGenerateTestSupportMethodAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testIntegration/BaseGenerateTestSupportMethodAction", "isValidForFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testIntegration/BaseGenerateTestSupportMethodAction", "isValidForFile"));
        }
        if (file2 instanceof PsiCompiledElement) {
            return false;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiClass targetClass = this.getTargetClass(editor, file2);
        return targetClass != null && this.isValidForClass(targetClass);
    }

    protected boolean isValidFor(PsiClass targetClass, TestFramework framework) {
        return true;
    }

    private static void chooseAndPerform(Editor editor, List<TestFramework> frameworks, final Consumer<TestFramework> consumer) {
        if (frameworks.size() == 1) {
            consumer.consume((Object)frameworks.get(0));
            return;
        }
        JBList list = new JBList((Object[])frameworks.toArray(new TestFramework[frameworks.size()]));
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = super.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
                if (value == null) {
                    return result;
                }
                TestFramework framework = (TestFramework)value;
                this.setIcon(framework.getIcon());
                this.setText(framework.getName());
                return result;
            }
        });
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        builder.setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                return ((TestFramework)o).getName();
            }
        });
        builder.setTitle("Choose Framework").setItemChoosenCallback(new Runnable((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void run() {
                consumer.consume((Object)((TestFramework)this.val$list.getSelectedValue()));
            }
        }).setMovable(true).createPopup().showInBestPositionFor(editor);
    }

    private static class MyHandler
    implements CodeInsightActionHandler {
        private final TestIntegrationUtils.MethodKind myMethodKind;

        private MyHandler(TestIntegrationUtils.MethodKind methodKind) {
            this.myMethodKind = methodKind;
        }

        public void invoke(@NotNull Project project2, final @NotNull Editor editor, final @NotNull PsiFile file2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testIntegration/BaseGenerateTestSupportMethodAction$MyHandler", "invoke"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testIntegration/BaseGenerateTestSupportMethodAction$MyHandler", "invoke"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testIntegration/BaseGenerateTestSupportMethodAction$MyHandler", "invoke"));
            }
            final PsiClass targetClass = BaseGenerateTestSupportMethodAction.findTargetClass(editor, file2);
            ArrayList<TestFramework> frameworks = new ArrayList<TestFramework>(TestIntegrationUtils.findSuitableFrameworks(targetClass));
            Iterator iterator = frameworks.iterator();
            while (iterator.hasNext()) {
                if (this.myMethodKind.getFileTemplateDescriptor((TestFramework)iterator.next()) != null) continue;
                iterator.remove();
            }
            if (frameworks.isEmpty()) {
                return;
            }
            Consumer<TestFramework> consumer = new Consumer<TestFramework>(){

                public void consume(TestFramework framework) {
                    if (framework == null) {
                        return;
                    }
                    this.doGenerate(editor, file2, targetClass, framework);
                }
            };
            BaseGenerateTestSupportMethodAction.chooseAndPerform(editor, frameworks, (Consumer<TestFramework>)((Consumer)consumer));
        }

        private void doGenerate(final Editor editor, final PsiFile file2, final PsiClass targetClass, final TestFramework framework) {
            if (framework instanceof JavaTestFramework && ((JavaTestFramework)framework).isSingleConfig()) {
                PsiElement alreadyExist = null;
                switch (this.myMethodKind) {
                    case SET_UP: {
                        alreadyExist = framework.findSetUpMethod((PsiElement)targetClass);
                        break;
                    }
                    case TEAR_DOWN: {
                        alreadyExist = framework.findTearDownMethod((PsiElement)targetClass);
                        break;
                    }
                }
                if (alreadyExist instanceof PsiMethod) {
                    editor.getCaretModel().moveToOffset(alreadyExist.getNavigationElement().getTextOffset());
                    HintManager.getInstance().showErrorHint(editor, "Method " + ((PsiMethod)alreadyExist).getName() + " already exists");
                    return;
                }
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file2)) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)file2.getProject(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        PsiDocumentManager.getInstance((Project)file2.getProject()).commitAllDocuments();
                        PsiMethod method = MyHandler.generateDummyMethod(editor, file2);
                        if (method == null) {
                            return;
                        }
                        TestIntegrationUtils.runTestMethodTemplate(myMethodKind, framework, editor, targetClass, method, "name", false, null);
                    }
                    catch (IncorrectOperationException e) {
                        HintManager.getInstance().showErrorHint(editor, "Cannot generate method: " + e.getMessage());
                        LOG.warn((Throwable)e);
                    }
                }
            });
        }

        @Nullable
        private static PsiMethod generateDummyMethod(Editor editor, PsiFile file2) throws IncorrectOperationException {
            PsiMethod method = TestIntegrationUtils.createDummyMethod((PsiElement)file2);
            PsiGenerationInfo<PsiMethod> info = OverrideImplementUtil.createGenerationInfo(method);
            int offset = MyHandler.findOffsetToInsertMethodTo(editor, file2);
            GenerateMembersUtil.insertMembersAtOffset(file2, offset, Collections.singletonList(info));
            PsiMethod member = info.getPsiMember();
            return member != null ? CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(member) : null;
        }

        private static int findOffsetToInsertMethodTo(Editor editor, PsiFile file2) {
            int result = editor.getCaretModel().getOffset();
            PsiClass classAtCursor = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(result), PsiClass.class, (boolean)false);
            while (classAtCursor != null && !(classAtCursor.getParent() instanceof PsiFile)) {
                result = classAtCursor.getTextRange().getEndOffset();
                classAtCursor = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)classAtCursor, PsiClass.class);
            }
            return result;
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

