/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Location;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiElement;
import com.intellij.testIntegration.RecentTestRunner;
import com.intellij.testIntegration.TestLocator;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.PsiNavigateUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

class RecentTestsListPopup
extends ListPopupImpl {
    private final RecentTestRunner myTestRunner;
    private final TestLocator myLocator;

    public RecentTestsListPopup(ListPopupStep<String> popupStep, RecentTestRunner testRunner, TestLocator locator) {
        super(popupStep);
        this.myTestRunner = testRunner;
        this.myLocator = locator;
        this.shiftReleased();
        this.registerActions(this);
        String shift = SystemInfo.isMac ? "\u21e7" : "Shift";
        this.setAdText("Debug with " + shift + ", navigate with F4");
    }

    private void registerActions(ListPopupImpl popup) {
        popup.registerAction("alternate", KeyStroke.getKeyStroke("shift pressed SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentTestsListPopup.this.shiftPressed();
            }
        });
        popup.registerAction("restoreDefault", KeyStroke.getKeyStroke("released SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentTestsListPopup.this.shiftReleased();
            }
        });
        popup.registerAction("invokeAction", KeyStroke.getKeyStroke("shift ENTER"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentTestsListPopup.this.handleSelect(true);
            }
        });
        popup.registerAction("navigate", KeyStroke.getKeyStroke(115, 0), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Location location;
                Object[] values = RecentTestsListPopup.this.getSelectedValues();
                if (values.length == 1 && (location = RecentTestsListPopup.this.myLocator.getLocation(values[0].toString())) != null) {
                    RecentTestsListPopup.this.cancel();
                    PsiNavigateUtil.navigate((PsiElement)location.getPsiElement());
                }
            }
        });
    }

    private void shiftPressed() {
        this.setCaption("Debug Recent Tests");
        this.myTestRunner.setMode(RecentTestRunner.Mode.DEBUG);
    }

    private void shiftReleased() {
        this.setCaption("Run Recent Tests");
        this.myTestRunner.setMode(RecentTestRunner.Mode.RUN);
    }
}

