/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.ImageLoader;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppUIUtil {
    private static final String VENDOR_PREFIX = "jetbrains-";
    private static final int MIN_ICON_SIZE = 32;

    public static void updateWindowIcon(@NotNull Window window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ui/AppUIUtil", "updateWindowIcon"));
        }
        window.setIconImages(AppUIUtil.getAppIconImages());
    }

    private static List<Image> getAppIconImages() {
        String bigIconUrl;
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        ArrayList images = ContainerUtil.newArrayListWithCapacity((int)3);
        if (SystemInfo.isXWindow && (bigIconUrl = appInfo.getBigIconUrl()) != null) {
            images.add(ImageLoader.loadFromResource((String)bigIconUrl));
        }
        images.add(ImageLoader.loadFromResource((String)appInfo.getIconUrl()));
        images.add(ImageLoader.loadFromResource((String)appInfo.getSmallIconUrl()));
        return images;
    }

    public static void invokeLaterIfProjectAlive(final @NotNull Project project2, @NotNull Runnable runnable2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/AppUIUtil", "invokeLaterIfProjectAlive"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ui/AppUIUtil", "invokeLaterIfProjectAlive"));
        }
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            runnable2.run();
        } else {
            application.invokeLater(runnable2, new Condition(){

                public boolean value(Object o) {
                    return !project2.isOpen() || project2.isDisposed();
                }
            });
        }
    }

    public static void invokeOnEdt(Runnable runnable2) {
        AppUIUtil.invokeOnEdt(runnable2, null);
    }

    public static void invokeOnEdt(Runnable runnable2, @Nullable Condition expired) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (expired == null || !expired.value(null)) {
                runnable2.run();
            }
        } else if (expired == null) {
            application.invokeLater(runnable2);
        } else {
            application.invokeLater(runnable2, expired);
        }
    }

    public static void updateFrameClass() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Class<?> aClass = toolkit.getClass();
            if ("sun.awt.X11.XToolkit".equals(aClass.getName())) {
                ReflectionUtil.setField(aClass, (Object)toolkit, null, (String)"awtAppClassName", (Object)AppUIUtil.getFrameClass());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getFrameClass() {
        String name = ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
        String wmClass = VENDOR_PREFIX + StringUtil.replaceChar((String)name, (char)' ', (char)'-');
        if ("true".equals(System.getProperty("idea.debug.mode"))) {
            wmClass = wmClass + "-debug";
        }
        return PlatformUtils.isCommunityEdition() ? wmClass + "-ce" : wmClass;
    }

    public static void registerBundledFonts() {
        if (Registry.is((String)"ide.register.bundled.fonts")) {
            AppUIUtil.registerFont("/fonts/Inconsolata.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-Regular.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-Bold.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-It.ttf");
            AppUIUtil.registerFont("/fonts/SourceCodePro-BoldIt.ttf");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerFont(@NonNls String name) {
        URL url = AppUIUtil.class.getResource(name);
        if (url == null) {
            Logger.getInstance(AppUIUtil.class).warn("Resource missing: " + name);
            return;
        }
        try (InputStream is = url.openStream();){
            Font font = Font.createFont(0, is);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
        }
        catch (Throwable t) {
            Logger.getInstance(AppUIUtil.class).warn("Cannot register font: " + url, t);
        }
    }

    public static void hideToolWindowBalloon(final @NotNull String id, final @NotNull Project project2) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ui/AppUIUtil", "hideToolWindowBalloon"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/AppUIUtil", "hideToolWindowBalloon"));
        }
        AppUIUtil.invokeLaterIfProjectAlive(project2, new Runnable(){

            @Override
            public void run() {
                Balloon balloon = ToolWindowManager.getInstance((Project)project2).getToolWindowBalloon(id);
                if (balloon != null) {
                    balloon.hide();
                }
            }
        });
    }

    @Nullable
    public static String findIcon(String iconsPath) {
        File iconsDir = new File(iconsPath);
        for (String child : iconsDir.list()) {
            if (!child.endsWith(".svg")) continue;
            return iconsPath + '/' + child;
        }
        int max = 0;
        String iconPath = null;
        for (String child : iconsDir.list()) {
            String path;
            ImageIcon icon;
            int size;
            if (!child.endsWith(".png") || (size = (icon = new ImageIcon(path = iconsPath + '/' + child)).getIconHeight()) < 32 || size <= max || size != icon.getIconWidth()) continue;
            max = size;
            iconPath = path;
        }
        return iconPath;
    }
}

