/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.AbstractIntToIntMap;
import org.jetbrains.annotations.NotNull;

public class PermanentListIntToIntMap
extends AbstractIntToIntMap
implements IntToIntMap {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    @NotNull
    private final Flags myVisibleIndexes;
    private final int myLongSize;
    private final int myShortSize;
    private final int myBlockSize;
    @NotNull
    private final int[] myStrongShortIndexes;

    @NotNull
    public static IntToIntMap newInstance(@NotNull Flags visibleIndexes, int shortSize) {
        if (visibleIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleIndexes", "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap", "newInstance"));
        }
        IntToIntMap intToIntMap = PermanentListIntToIntMap.newInstance(visibleIndexes, shortSize, 30);
        if (intToIntMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap", "newInstance"));
        }
        return intToIntMap;
    }

    @NotNull
    public static IntToIntMap newInstance(@NotNull Flags visibleIndexes, int shortSize, int blockSize) {
        if (visibleIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleIndexes", "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap", "newInstance"));
        }
        if (shortSize < 0) {
            throw new NegativeArraySizeException("shortSize < 0: " + shortSize);
        }
        if (shortSize == 0) {
            IntToIntMap intToIntMap = PermanentListIntToIntMap.createEmptyIntToIntMap(visibleIndexes);
            if (intToIntMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap", "newInstance"));
            }
            return intToIntMap;
        }
        int[] strongShortIndexes = new int[(shortSize - 1) / blockSize + 1];
        int currentShortIndex = -1;
        for (int longIndex = 0; longIndex < visibleIndexes.size(); ++longIndex) {
            if (!visibleIndexes.get(longIndex) || ++currentShortIndex % blockSize != 0) continue;
            strongShortIndexes[currentShortIndex / blockSize] = longIndex;
        }
        PermanentListIntToIntMap permanentListIntToIntMap = new PermanentListIntToIntMap(visibleIndexes, shortSize, blockSize, strongShortIndexes);
        if (permanentListIntToIntMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap", "newInstance"));
        }
        return permanentListIntToIntMap;
    }

    @NotNull
    private static IntToIntMap createEmptyIntToIntMap(final @NotNull Flags visibleIndexes) {
        if (visibleIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleIndexes", "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap", "createEmptyIntToIntMap"));
        }
        IntToIntMap intToIntMap = new IntToIntMap(){

            @Override
            public int shortSize() {
                return 0;
            }

            @Override
            public int longSize() {
                return visibleIndexes.size();
            }

            @Override
            public int getLongIndex(int shortIndex) {
                return 0;
            }

            @Override
            public int getShortIndex(int longIndex) {
                return 0;
            }
        };
        if (intToIntMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap", "createEmptyIntToIntMap"));
        }
        return intToIntMap;
    }

    private PermanentListIntToIntMap(@NotNull Flags visibleIndexes, int shortSize, int blockSize, @NotNull int[] strongShortIndexes) {
        if (visibleIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleIndexes", "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap", "<init>"));
        }
        if (strongShortIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strongShortIndexes", "com/intellij/vcs/log/graph/utils/impl/PermanentListIntToIntMap", "<init>"));
        }
        this.myVisibleIndexes = visibleIndexes;
        this.myLongSize = visibleIndexes.size();
        this.myShortSize = shortSize;
        this.myBlockSize = blockSize;
        this.myStrongShortIndexes = strongShortIndexes;
    }

    @Override
    public int shortSize() {
        return this.myShortSize;
    }

    @Override
    public int longSize() {
        return this.myLongSize;
    }

    @Override
    public int getLongIndex(int shortIndex) {
        this.checkShortIndex(shortIndex);
        int strongIndex = shortIndex / this.myBlockSize;
        int sub = shortIndex - strongIndex * this.myBlockSize;
        for (int longIndex = this.myStrongShortIndexes[strongIndex]; longIndex < this.myLongSize; ++longIndex) {
            if (this.myVisibleIndexes.get(longIndex)) {
                --sub;
            }
            if (sub != -1) continue;
            return longIndex;
        }
        throw new IllegalStateException("Not found long index for short index: " + shortIndex + ". Long & short size is: " + this.myLongSize + ", " + this.myShortSize + ".");
    }
}

