/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import com.intellij.vcs.log.ui.filter.FlatSpeedSearchPopup;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogBranchFilter> {
    @NotNull
    private final VcsLogUiImpl myUi;
    private VcsLogClassicFilterUi.BranchFilterModel myBranchFilterModel;

    public BranchFilterPopupComponent(@NotNull VcsLogUiImpl ui, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogClassicFilterUi.BranchFilterModel filterModel) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "<init>"));
        }
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "<init>"));
        }
        super("Branch", uiProperties, filterModel);
        this.myUi = ui;
        this.myBranchFilterModel = filterModel;
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogBranchFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getText"));
        }
        String string = BranchFilterPopupComponent.displayableText(this.getTextValues(filter));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getText"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogBranchFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getToolTip"));
        }
        return BranchFilterPopupComponent.tooltip(this.getTextValues(filter));
    }

    @Override
    @NotNull
    protected VcsLogBranchFilter createFilter(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "createFilter"));
        }
        VcsLogBranchFilterImpl vcsLogBranchFilterImpl = VcsLogBranchFilterImpl.fromTextPresentation(values, ContainerUtil.map2Set((Collection)this.myUi.getDataPack().getRefs().getBranches(), (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef vcsRef) {
                return vcsRef.getName();
            }
        }));
        if (vcsLogBranchFilterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "createFilter"));
        }
        return vcsLogBranchFilterImpl;
    }

    @Override
    @NotNull
    protected Collection<String> getTextValues(@Nullable VcsLogBranchFilter filter) {
        if (filter == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getTextValues"));
            }
            return set;
        }
        Collection collection = filter.getTextPresentation();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getTextValues"));
        }
        return collection;
    }

    @Override
    protected boolean supportsNegativeValues() {
        return true;
    }

    @Override
    @NotNull
    protected ListPopup createPopupMenu() {
        FlatSpeedSearchPopup flatSpeedSearchPopup = new FlatSpeedSearchPopup(this.createActionGroup(), DataManager.getInstance().getDataContext((Component)this));
        if (flatSpeedSearchPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "createPopupMenu"));
        }
        return flatSpeedSearchPopup;
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(this.createAllAction());
        actionGroup.add(this.createSelectMultipleValuesAction());
        actionGroup.add((AnAction)new MyBranchPopupBuilder(this.myFilterModel.getDataPack(), this.myBranchFilterModel.getVisibleRoots(), this.getRecentValuesFromSettings()).build());
        return actionGroup;
    }

    @Override
    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        List<List<String>> list = this.myUiProperties.getRecentlyFilteredBranchGroups();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getRecentValuesFromSettings"));
        }
        return list;
    }

    @Override
    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "rememberValuesInSettings"));
        }
        this.myUiProperties.addRecentlyFilteredBranchGroup(new ArrayList<String>(values));
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        List list = ContainerUtil.map((Collection)this.myFilterModel.getDataPack().getRefs().getBranches(), (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef ref) {
                return ref.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent", "getAllValues"));
        }
        return list;
    }

    private class MyBranchPopupBuilder
    extends BranchPopupBuilder {
        protected MyBranchPopupBuilder(@Nullable VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, List<List<String>> recentItems) {
            if (dataPack == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent$MyBranchPopupBuilder", "<init>"));
            }
            super(dataPack, visibleRoots, recentItems);
        }

        @Override
        @NotNull
        public AnAction createAction(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent$MyBranchPopupBuilder", "createAction"));
            }
            MultipleValueFilterPopupComponent.PredefinedValueAction predefinedValueAction = new MultipleValueFilterPopupComponent.PredefinedValueAction(Collections.singleton(name)){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent$MyBranchPopupBuilder$1", "actionPerformed"));
                    }
                    BranchFilterPopupComponent.this.myFilterModel.setFilter(BranchFilterPopupComponent.this.createFilter((Collection<String>)this.myValues));
                }
            };
            if (predefinedValueAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent$MyBranchPopupBuilder", "createAction"));
            }
            return predefinedValueAction;
        }

        @Override
        protected void createRecentAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> recentItem) {
            if (actionGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent$MyBranchPopupBuilder", "createRecentAction"));
            }
            if (recentItem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recentItem", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent$MyBranchPopupBuilder", "createRecentAction"));
            }
            actionGroup.add((AnAction)new MultipleValueFilterPopupComponent.PredefinedValueAction(BranchFilterPopupComponent.this, recentItem));
        }

        @Override
        @NotNull
        protected AnAction createCollapsedAction(String actionName) {
            AnAction anAction = BranchFilterPopupComponent.this.createPredefinedValueAction(Collections.singleton(actionName));
            if (anAction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/BranchFilterPopupComponent$MyBranchPopupBuilder", "createCollapsedAction"));
            }
            return anAction;
        }
    }
}

