/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.ui.VcsLogPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FilterPopupComponent<Filter extends VcsLogFilter>
extends VcsLogPopupComponent {
    protected static final String ALL = "All";
    @NotNull
    protected final FilterModel<Filter> myFilterModel;

    FilterPopupComponent(@NotNull String filterName, @NotNull FilterModel<Filter> filterModel) {
        if (filterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterName", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "<init>"));
        }
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "<init>"));
        }
        super(filterName);
        this.myFilterModel = filterModel;
    }

    @Override
    public String getCurrentText() {
        Filter filter = this.myFilterModel.getFilter();
        return filter == null ? ALL : this.getText(filter);
    }

    @Override
    public void installChangeListener(@NotNull Runnable onChange) {
        if (onChange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onChange", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "installChangeListener"));
        }
        this.myFilterModel.addSetFilterListener(onChange);
    }

    @NotNull
    protected abstract String getText(@NotNull Filter var1);

    @Nullable
    protected abstract String getToolTip(@NotNull Filter var1);

    @Override
    public String getToolTipText() {
        Filter filter = this.myFilterModel.getFilter();
        return filter == null ? null : this.getToolTip(filter);
    }

    @NotNull
    protected AnAction createAllAction() {
        AllAction allAction = new AllAction();
        if (allAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "createAllAction"));
        }
        return allAction;
    }

    private class AllAction
    extends DumbAwareAction {
        AllAction() {
            super(FilterPopupComponent.ALL);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/FilterPopupComponent$AllAction", "actionPerformed"));
            }
            FilterPopupComponent.this.myFilterModel.setFilter(null);
        }
    }
}

