/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.ManagePackagesDialog;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.intellij.webcore.packaging.RepoPackage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPackagesPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(InstalledPackagesPanel.class);
    private final AnActionButton myUpgradeButton;
    protected final AnActionButton myInstallButton;
    private final AnActionButton myUninstallButton;
    protected final JBTable myPackagesTable;
    private DefaultTableModel myPackagesTableModel;
    protected volatile PackageManagementService myPackageManagementService;
    protected final Project myProject;
    protected final PackagesNotificationPanel myNotificationArea;
    private final Set<String> myCurrentlyInstalling = ContainerUtil.newHashSet();
    private final Set<InstalledPackage> myWaitingToUpgrade = ContainerUtil.newHashSet();

    public InstalledPackagesPanel(Project project2, PackagesNotificationPanel area) {
        super(new BorderLayout());
        this.myProject = project2;
        this.myNotificationArea = area;
        this.myPackagesTableModel = new DefaultTableModel(new String[]{"Package", "Version", "Latest"}, 0){

            @Override
            public boolean isCellEditable(int i, int i1) {
                return false;
            }
        };
        final MyTableCellRenderer tableCellRenderer = new MyTableCellRenderer();
        this.myPackagesTable = new JBTable(this.myPackagesTableModel){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return tableCellRenderer;
            }
        };
        this.myPackagesTable.setPreferredScrollableViewportSize(null);
        this.myPackagesTable.setStriped(true);
        this.myPackagesTable.getTableHeader().setReorderingAllowed(false);
        this.myUpgradeButton = new AnActionButton("Upgrade", IconUtil.getMoveUpIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/InstalledPackagesPanel$3", "actionPerformed"));
                }
                InstalledPackagesPanel.this.upgradeAction();
            }
        };
        this.myInstallButton = new AnActionButton("Install", IconUtil.getAddIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/InstalledPackagesPanel$4", "actionPerformed"));
                }
                if (InstalledPackagesPanel.this.myPackageManagementService != null) {
                    ManagePackagesDialog dialog = InstalledPackagesPanel.this.createManagePackagesDialog();
                    dialog.show();
                }
            }
        };
        this.myUninstallButton = new AnActionButton("Uninstall", IconUtil.getRemoveIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/InstalledPackagesPanel$5", "actionPerformed"));
                }
                InstalledPackagesPanel.this.uninstallAction();
            }
        };
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myPackagesTable).disableUpDownActions().disableAddAction().disableRemoveAction().addExtraAction(this.myInstallButton).addExtraAction(this.myUninstallButton).addExtraAction(this.myUpgradeButton);
        this.add(decorator.createPanel());
        this.myInstallButton.setEnabled(false);
        this.myUninstallButton.setEnabled(false);
        this.myUpgradeButton.setEnabled(false);
        this.myPackagesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                InstalledPackagesPanel.this.updateUninstallUpgrade();
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (InstalledPackagesPanel.this.myPackageManagementService != null && InstalledPackagesPanel.this.myInstallButton.isEnabled()) {
                    Object pkg;
                    ManagePackagesDialog dialog = InstalledPackagesPanel.this.createManagePackagesDialog();
                    Point p = e.getPoint();
                    int row = InstalledPackagesPanel.this.myPackagesTable.rowAtPoint(p);
                    int column = InstalledPackagesPanel.this.myPackagesTable.columnAtPoint(p);
                    if (row >= 0 && column >= 0 && (pkg = InstalledPackagesPanel.this.myPackagesTable.getValueAt(row, 0)) instanceof InstalledPackage) {
                        dialog.selectPackage((InstalledPackage)pkg);
                    }
                    dialog.show();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myPackagesTable);
    }

    @NotNull
    protected ManagePackagesDialog createManagePackagesDialog() {
        ManagePackagesDialog managePackagesDialog = new ManagePackagesDialog(this.myProject, this.myPackageManagementService, new PackageManagementService.Listener(){

            @Override
            public void operationStarted(String packageName) {
                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
            }

            @Override
            public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                InstalledPackagesPanel.this.myNotificationArea.showResult(packageName, errorDescription);
                InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                InstalledPackagesPanel.this.doUpdatePackages(InstalledPackagesPanel.this.myPackageManagementService);
            }
        });
        if (managePackagesDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/packaging/InstalledPackagesPanel", "createManagePackagesDialog"));
        }
        return managePackagesDialog;
    }

    private void upgradeAction() {
        int[] rows = this.myPackagesTable.getSelectedRows();
        if (this.myPackageManagementService != null) {
            HashSet upgradedPackages = new HashSet();
            Set<String> packagesShouldBePostponed = this.getPackagesToPostpone();
            for (int row : rows) {
                Object packageObj = this.myPackagesTableModel.getValueAt(row, 0);
                if (!(packageObj instanceof InstalledPackage)) continue;
                InstalledPackage pkg = (InstalledPackage)packageObj;
                String packageName = pkg.getName();
                String currentVersion = pkg.getVersion();
                String availableVersion = (String)this.myPackagesTableModel.getValueAt(row, 2);
                if (packagesShouldBePostponed.contains(packageName)) {
                    this.myWaitingToUpgrade.add((InstalledPackage)packageObj);
                    continue;
                }
                if (!this.isUpdateAvailable(currentVersion, availableVersion)) continue;
                this.upgradePackage(pkg, availableVersion);
                upgradedPackages.add(packageName);
            }
            if (this.myCurrentlyInstalling.isEmpty() && upgradedPackages.isEmpty() && !this.myWaitingToUpgrade.isEmpty()) {
                this.upgradePostponedPackages();
            }
        }
    }

    private void upgradePostponedPackages() {
        Iterator<InstalledPackage> iterator = this.myWaitingToUpgrade.iterator();
        InstalledPackage toUpgrade = iterator.next();
        iterator.remove();
        this.upgradePackage(toUpgrade, toUpgrade.getVersion());
    }

    protected Set<String> getPackagesToPostpone() {
        return Collections.emptySet();
    }

    private void upgradePackage(final @NotNull InstalledPackage pkg, final @Nullable String toVersion) {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/webcore/packaging/InstalledPackagesPanel", "upgradePackage"));
        }
        final PackageManagementService selPackageManagementService = this.myPackageManagementService;
        this.myPackageManagementService.fetchPackageVersions(pkg.getName(), new CatchingConsumer<List<String>, Exception>(){

            public void consume(List<String> releases) {
                if (!releases.isEmpty() && !InstalledPackagesPanel.this.isUpdateAvailable(pkg.getVersion(), releases.get(0))) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

                            @Override
                            public void operationStarted(final String packageName) {
                                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
                                        InstalledPackagesPanel.this.myCurrentlyInstalling.add(packageName);
                                    }
                                });
                            }

                            @Override
                            public void operationFinished(final String packageName, final @Nullable PackageManagementService.ErrorDescription errorDescription) {
                                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                                        InstalledPackagesPanel.this.updatePackages(selPackageManagementService);
                                        InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(false);
                                        InstalledPackagesPanel.this.myCurrentlyInstalling.remove(packageName);
                                        if (errorDescription == null) {
                                            InstalledPackagesPanel.this.myNotificationArea.showSuccess("Package " + packageName + " successfully upgraded");
                                        } else {
                                            InstalledPackagesPanel.this.myNotificationArea.showError("Upgrade packages failed. <a href=\"xxx\">Details...</a>", "Upgrade Packages Failed", errorDescription);
                                        }
                                        if (InstalledPackagesPanel.this.myCurrentlyInstalling.isEmpty() && !InstalledPackagesPanel.this.myWaitingToUpgrade.isEmpty()) {
                                            InstalledPackagesPanel.this.upgradePostponedPackages();
                                        }
                                    }
                                });
                            }
                        };
                        PackageManagementServiceEx serviceEx = InstalledPackagesPanel.this.getServiceEx();
                        if (serviceEx != null) {
                            serviceEx.updatePackage(pkg, toVersion, listener2);
                        } else {
                            InstalledPackagesPanel.this.myPackageManagementService.installPackage(new RepoPackage(pkg.getName(), null), null, true, null, listener2, false);
                        }
                        InstalledPackagesPanel.this.myUpgradeButton.setEnabled(false);
                    }
                }, ModalityState.any());
            }

            public void consume(Exception e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)"Error occurred. Please, check your internet connection.", (String)"Upgrade Package Failed.");
                    }
                }, ModalityState.any());
            }
        });
    }

    @Nullable
    private PackageManagementServiceEx getServiceEx() {
        return (PackageManagementServiceEx)ObjectUtils.tryCast((Object)this.myPackageManagementService, PackageManagementServiceEx.class);
    }

    private void updateUninstallUpgrade() {
        int[] selected = this.myPackagesTable.getSelectedRows();
        boolean upgradeAvailable = false;
        boolean canUninstall = selected.length != 0;
        boolean canInstall = this.installEnabled();
        boolean canUpgrade = true;
        if (this.myPackageManagementService != null && selected.length != 0) {
            for (int i = 0; i != selected.length; ++i) {
                Object value;
                int index = selected[i];
                if (index >= this.myPackagesTable.getRowCount() || !((value = this.myPackagesTable.getValueAt(index, 0)) instanceof InstalledPackage)) continue;
                InstalledPackage pkg = (InstalledPackage)value;
                if (!this.canUninstallPackage(pkg)) {
                    canUninstall = false;
                }
                canInstall = this.canInstallPackage(pkg);
                if (!this.canUpgradePackage(pkg)) {
                    canUpgrade = false;
                }
                String pyPackageName = pkg.getName();
                String availableVersion = (String)this.myPackagesTable.getValueAt(index, 2);
                if (!upgradeAvailable) {
                    boolean bl = upgradeAvailable = this.isUpdateAvailable(pkg.getVersion(), availableVersion) && !this.myCurrentlyInstalling.contains(pyPackageName);
                }
                if (!canUninstall && !canUpgrade) break;
            }
        }
        this.myUninstallButton.setEnabled(canUninstall);
        this.myInstallButton.setEnabled(canInstall);
        this.myUpgradeButton.setEnabled(upgradeAvailable && canUpgrade);
    }

    protected boolean canUninstallPackage(InstalledPackage pyPackage) {
        return true;
    }

    protected boolean canInstallPackage(@NotNull InstalledPackage pyPackage) {
        if (pyPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyPackage", "com/intellij/webcore/packaging/InstalledPackagesPanel", "canInstallPackage"));
        }
        return true;
    }

    protected boolean installEnabled() {
        return true;
    }

    protected boolean canUpgradePackage(InstalledPackage pyPackage) {
        return true;
    }

    private void uninstallAction() {
        List<InstalledPackage> packages = this.getSelectedPackages();
        final PackageManagementService selPackageManagementService = this.myPackageManagementService;
        if (selPackageManagementService != null) {
            PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

                @Override
                public void operationStarted(String packageName) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(true);
                        }
                    });
                }

                @Override
                public void operationFinished(final String packageName, final @Nullable PackageManagementService.ErrorDescription errorDescription) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            InstalledPackagesPanel.this.myPackagesTable.clearSelection();
                            InstalledPackagesPanel.this.updatePackages(selPackageManagementService);
                            InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(false);
                            if (errorDescription == null) {
                                if (packageName != null) {
                                    InstalledPackagesPanel.this.myNotificationArea.showSuccess("Package '" + packageName + "' successfully uninstalled");
                                } else {
                                    InstalledPackagesPanel.this.myNotificationArea.showSuccess("Packages successfully uninstalled");
                                }
                            } else {
                                InstalledPackagesPanel.this.myNotificationArea.showError("Uninstall packages failed. <a href=\"xxx\">Details...</a>", "Uninstall Packages Failed", errorDescription);
                            }
                        }
                    });
                }
            };
            this.myPackageManagementService.uninstallPackages(packages, listener2);
        }
    }

    @NotNull
    private List<InstalledPackage> getSelectedPackages() {
        int[] rows;
        ArrayList<InstalledPackage> results = new ArrayList<InstalledPackage>();
        for (int row : rows = this.myPackagesTable.getSelectedRows()) {
            Object packageName = this.myPackagesTableModel.getValueAt(row, 0);
            if (!(packageName instanceof InstalledPackage)) continue;
            results.add((InstalledPackage)packageName);
        }
        ArrayList<InstalledPackage> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/packaging/InstalledPackagesPanel", "getSelectedPackages"));
        }
        return arrayList;
    }

    public void updatePackages(@Nullable PackageManagementService packageManagementService) {
        this.myPackageManagementService = packageManagementService;
        this.myPackagesTable.clearSelection();
        this.myPackagesTableModel.getDataVector().clear();
        this.myPackagesTableModel.fireTableDataChanged();
        if (packageManagementService != null) {
            this.doUpdatePackages(packageManagementService);
        }
    }

    private void onUpdateStarted() {
        this.myPackagesTable.setPaintBusy(true);
        this.myPackagesTable.getEmptyText().setText("Loading...");
    }

    private void onUpdateFinished() {
        this.myPackagesTable.setPaintBusy(false);
        this.myPackagesTable.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
        this.updateUninstallUpgrade();
        ActivityTracker.getInstance().inc();
    }

    public void doUpdatePackages(final @NotNull PackageManagementService packageManagementService) {
        if (packageManagementService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageManagementService", "com/intellij/webcore/packaging/InstalledPackagesPanel", "doUpdatePackages"));
        }
        this.onUpdateStarted();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Collection<Object> finalPackages;
                Collection<Object> packages = Lists.newArrayList();
                try {
                    finalPackages = packages = packageManagementService.getInstalledPackages();
                }
                catch (IOException e) {
                    Collection<Object> finalPackages2;
                    try {
                        LOG.warn(e.getMessage());
                        finalPackages2 = packages;
                    }
                    catch (Throwable throwable) {
                        ArrayList finalPackages3 = packages;
                        Map cache = InstalledPackagesPanel.buildNameToPackageMap(packageManagementService.getAllPackagesCached());
                        boolean shouldFetchLatestVersionsForOnlyInstalledPackages = InstalledPackagesPanel.this.shouldFetchLatestVersionsForOnlyInstalledPackages();
                        if (cache.isEmpty() && !shouldFetchLatestVersionsForOnlyInstalledPackages) {
                            InstalledPackagesPanel.this.refreshLatestVersions(packageManagementService);
                        }
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(finalPackages3, cache, shouldFetchLatestVersionsForOnlyInstalledPackages){
                            final /* synthetic */ Collection val$finalPackages;
                            final /* synthetic */ Map val$cache;
                            final /* synthetic */ boolean val$shouldFetchLatestVersionsForOnlyInstalledPackages;
                            {
                                this.val$finalPackages = collection;
                                this.val$cache = map;
                                this.val$shouldFetchLatestVersionsForOnlyInstalledPackages = bl;
                            }

                            @Override
                            public void run() {
                                if (packageManagementService == InstalledPackagesPanel.this.myPackageManagementService) {
                                    InstalledPackagesPanel.this.myPackagesTableModel.getDataVector().clear();
                                    for (InstalledPackage pkg : this.val$finalPackages) {
                                        RepoPackage repoPackage = (RepoPackage)this.val$cache.get(pkg.getName());
                                        String version = repoPackage != null ? repoPackage.getLatestVersion() : null;
                                        InstalledPackagesPanel.this.myPackagesTableModel.addRow(new Object[]{pkg, pkg.getVersion(), version == null ? "" : version});
                                    }
                                    if (!this.val$cache.isEmpty()) {
                                        InstalledPackagesPanel.this.onUpdateFinished();
                                    }
                                    if (this.val$shouldFetchLatestVersionsForOnlyInstalledPackages) {
                                        InstalledPackagesPanel.this.setLatestVersionsForInstalledPackages();
                                    }
                                }
                            }
                        });
                        throw throwable;
                    }
                    Map cache = InstalledPackagesPanel.buildNameToPackageMap(packageManagementService.getAllPackagesCached());
                    boolean shouldFetchLatestVersionsForOnlyInstalledPackages = InstalledPackagesPanel.this.shouldFetchLatestVersionsForOnlyInstalledPackages();
                    if (cache.isEmpty() && !shouldFetchLatestVersionsForOnlyInstalledPackages) {
                        InstalledPackagesPanel.this.refreshLatestVersions(packageManagementService);
                    }
                    UIUtil.invokeLaterIfNeeded((Runnable)new /* invalid duplicate definition of identical inner class */);
                }
                Map cache = InstalledPackagesPanel.buildNameToPackageMap(packageManagementService.getAllPackagesCached());
                boolean shouldFetchLatestVersionsForOnlyInstalledPackages = InstalledPackagesPanel.this.shouldFetchLatestVersionsForOnlyInstalledPackages();
                if (cache.isEmpty() && !shouldFetchLatestVersionsForOnlyInstalledPackages) {
                    InstalledPackagesPanel.this.refreshLatestVersions(packageManagementService);
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private InstalledPackage getInstalledPackageAt(int index) {
        return (InstalledPackage)this.myPackagesTableModel.getValueAt(index, 0);
    }

    private void setLatestVersionsForInstalledPackages() {
        PackageManagementServiceEx serviceEx = this.getServiceEx();
        if (serviceEx == null) {
            return;
        }
        int packageCount = this.myPackagesTableModel.getRowCount();
        if (packageCount == 0) {
            this.onUpdateFinished();
        }
        final AtomicInteger inProgressPackageCount = new AtomicInteger(packageCount);
        int i = 0;
        while (i < packageCount) {
            final int finalIndex = i++;
            final InstalledPackage pkg = this.getInstalledPackageAt(finalIndex);
            serviceEx.fetchLatestVersion(pkg, new CatchingConsumer<String, Exception>(){

                private void decrement() {
                    if (inProgressPackageCount.decrementAndGet() == 0) {
                        InstalledPackagesPanel.this.onUpdateFinished();
                    }
                }

                public void consume(Exception e) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            this.decrement();
                        }
                    });
                }

                public void consume(final @Nullable String latestVersion) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            InstalledPackage p;
                            if (finalIndex < InstalledPackagesPanel.this.myPackagesTableModel.getRowCount() && pkg == (p = InstalledPackagesPanel.this.getInstalledPackageAt(finalIndex))) {
                                InstalledPackagesPanel.this.myPackagesTableModel.setValueAt(latestVersion, finalIndex, 2);
                            }
                            this.decrement();
                        }
                    });
                }
            });
        }
    }

    private boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        PackageManagementServiceEx serviceEx = this.getServiceEx();
        if (serviceEx != null) {
            return serviceEx.shouldFetchLatestVersionsForOnlyInstalledPackages();
        }
        return false;
    }

    private boolean isUpdateAvailable(@Nullable String currentVersion, @Nullable String availableVersion) {
        if (availableVersion == null) {
            return false;
        }
        if (currentVersion == null) {
            return true;
        }
        PackageManagementService service = this.myPackageManagementService;
        if (service != null) {
            return service.compareVersions(currentVersion, availableVersion) < 0;
        }
        return PackageVersionComparator.VERSION_COMPARATOR.compare(currentVersion, availableVersion) < 0;
    }

    private void refreshLatestVersions(final @NotNull PackageManagementService packageManagementService) {
        if (packageManagementService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageManagementService", "com/intellij/webcore/packaging/InstalledPackagesPanel", "refreshLatestVersions"));
        }
        final Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (packageManagementService == InstalledPackagesPanel.this.myPackageManagementService) {
                    try {
                        List<RepoPackage> packages = packageManagementService.reloadAllPackages();
                        final Map packageMap = InstalledPackagesPanel.buildNameToPackageMap(packages);
                        application.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = 0; i != InstalledPackagesPanel.this.myPackagesTableModel.getRowCount(); ++i) {
                                    InstalledPackage pyPackage = (InstalledPackage)InstalledPackagesPanel.this.myPackagesTableModel.getValueAt(i, 0);
                                    RepoPackage repoPackage = (RepoPackage)packageMap.get(pyPackage.getName());
                                    InstalledPackagesPanel.this.myPackagesTableModel.setValueAt(repoPackage == null ? null : repoPackage.getLatestVersion(), i, 2);
                                }
                                InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(false);
                            }
                        }, ModalityState.stateForComponent((Component)InstalledPackagesPanel.this.myPackagesTable));
                    }
                    catch (IOException ignored) {
                        InstalledPackagesPanel.this.myPackagesTable.setPaintBusy(false);
                    }
                }
            }
        });
    }

    private static Map<String, RepoPackage> buildNameToPackageMap(List<RepoPackage> packages) {
        HashMap<String, RepoPackage> packageMap = new HashMap<String, RepoPackage>();
        for (RepoPackage aPackage : packages) {
            packageMap.put(aPackage.getName(), aPackage);
        }
        return packageMap;
    }

    private class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String version = (String)table.getValueAt(row, 1);
            String availableVersion = (String)table.getValueAt(row, 2);
            boolean update = column == 2 && StringUtil.isNotEmpty((String)availableVersion) && InstalledPackagesPanel.this.isUpdateAvailable(version, availableVersion);
            cell.setIcon(update ? AllIcons.Vcs.Arrow_right : null);
            Object pyPackage = table.getValueAt(row, 0);
            if (pyPackage instanceof InstalledPackage) {
                cell.setToolTipText(((InstalledPackage)pyPackage).getTooltipText());
            }
            return cell;
        }
    }
}

