/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaPropertyProcessor {
    public static boolean process(@NotNull PropertyProcessor processor2, @NotNull JsonSchemaObject startSchema) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/jsonSchema/impl/JsonSchemaPropertyProcessor", "process"));
        }
        if (startSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaPropertyProcessor", "process"));
        }
        if (!(JsonSchemaPropertyProcessor.processForVariants(processor2, startSchema.getAnyOf()) && JsonSchemaPropertyProcessor.processForVariants(processor2, startSchema.getOneOf()) && JsonSchemaPropertyProcessor.processForVariants(processor2, startSchema.getAllOf()))) {
            return false;
        }
        Map<String, JsonSchemaObject> properties = startSchema.getProperties();
        for (Map.Entry<String, JsonSchemaObject> entry : properties.entrySet()) {
            if (processor2.process(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean processForVariants(@NotNull PropertyProcessor processor2, @Nullable List<JsonSchemaObject> list) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/jetbrains/jsonSchema/impl/JsonSchemaPropertyProcessor", "processForVariants"));
        }
        if (list != null && list.size() > 0) {
            for (JsonSchemaObject schemaObject : list) {
                if (JsonSchemaPropertyProcessor.process(processor2, schemaObject)) continue;
                return false;
            }
        }
        return true;
    }

    public static interface PropertyProcessor {
        public boolean process(String var1, JsonSchemaObject var2);
    }
}

