/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantConditionalExpressionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiConditionalExpression expression = (PsiConditionalExpression)infos[0];
        String string = InspectionGadgetsBundle.message("constant.conditional.expression.problem.descriptor", ConstantConditionalExpressionInspection.calculateReplacementExpression(expression));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection", "buildErrorString"));
        }
        return string;
    }

    static String calculateReplacementExpression(PsiConditionalExpression exp) {
        PsiExpression thenExpression = exp.getThenExpression();
        PsiExpression elseExpression = exp.getElseExpression();
        PsiExpression condition = exp.getCondition();
        assert (thenExpression != null);
        assert (elseExpression != null);
        if (BoolUtils.isTrue(condition)) {
            return thenExpression.getText();
        }
        return elseExpression.getText();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConstantConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantConditionalExpressionVisitor();
    }

    private static class ConstantConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConstantConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            PsiExpression condition = expression.getCondition();
            PsiExpression thenExpression = expression.getThenExpression();
            if (thenExpression == null) {
                return;
            }
            PsiExpression elseExpression = expression.getElseExpression();
            if (elseExpression == null) {
                return;
            }
            if (BoolUtils.isFalse(condition) || BoolUtils.isTrue(condition)) {
                this.registerError((PsiElement)expression, expression);
            }
        }
    }

    private static class ConstantConditionalFix
    extends InspectionGadgetsFix {
        private ConstantConditionalFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection$ConstantConditionalFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection$ConstantConditionalFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiConditionalExpression expression = (PsiConditionalExpression)descriptor.getPsiElement();
            String newExpression = ConstantConditionalExpressionInspection.calculateReplacementExpression(expression);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression);
        }
    }
}

