/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryConstructorInspection
extends BaseInspection {
    public boolean ignoreAnnotations = false;

    @NotNull
    public String getID() {
        if ("RedundantNoArgConstructor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryConstructorInspection", "getID"));
        }
        return "RedundantNoArgConstructor";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.constructor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryConstructorInspection", "getDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.constructor.annotation.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAnnotations");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryConstructorInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConstructorVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryConstructorFix();
    }

    private class UnnecessaryConstructorVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiModifierList modifierList;
            PsiAnnotation[] annotations;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/style/UnnecessaryConstructorInspection$UnnecessaryConstructorVisitor", "visitClass"));
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length != 1) {
                return;
            }
            PsiMethod constructor = constructors[0];
            if (!constructor.isPhysical() || constructor.getNameIdentifier() == null) {
                return;
            }
            if (!constructor.hasModifierProperty("private") && aClass.hasModifierProperty("private")) {
                return;
            }
            if (!constructor.hasModifierProperty("packageLocal") && aClass.hasModifierProperty("packageLocal")) {
                return;
            }
            if (!constructor.hasModifierProperty("protected") && aClass.hasModifierProperty("protected")) {
                return;
            }
            if (!constructor.hasModifierProperty("public") && aClass.hasModifierProperty("public")) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            if (UnnecessaryConstructorInspection.this.ignoreAnnotations && (annotations = (modifierList = constructor.getModifierList()).getAnnotations()).length > 0) {
                return;
            }
            PsiReferenceList throwsList = constructor.getThrowsList();
            PsiJavaCodeReferenceElement[] elements = throwsList.getReferenceElements();
            if (elements.length != 0) {
                return;
            }
            PsiCodeBlock body = constructor.getBody();
            if (ControlFlowUtils.isEmptyCodeBlock(body)) {
                this.registerMethodError(constructor, new Object[0]);
            } else if (this.isSuperConstructorInvocationWithoutArguments(ControlFlowUtils.getOnlyStatementInBlock(body))) {
                this.registerMethodError(constructor, new Object[0]);
            }
        }

        private boolean isSuperConstructorInvocationWithoutArguments(PsiStatement statement2) {
            if (!(statement2 instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement2;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            return "super".equals(methodExpression.getReferenceName());
        }
    }

    private static class UnnecessaryConstructorFix
    extends InspectionGadgetsFix {
        private UnnecessaryConstructorFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.constructor.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryConstructorInspection$UnnecessaryConstructorFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryConstructorInspection$UnnecessaryConstructorFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement nameIdentifier = descriptor.getPsiElement();
            PsiElement constructor = nameIdentifier.getParent();
            assert (constructor != null);
            UnnecessaryConstructorFix.deleteElement(constructor);
        }
    }
}

