/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class PostfixPrefixIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                IElementType tokenType;
                if (element instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
                    tokenType = prefixExpression.getOperationTokenType();
                    if (prefixExpression.getOperand() == null) {
                        return false;
                    }
                } else if (element instanceof PsiPostfixExpression) {
                    PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
                    tokenType = postfixExpression.getOperationTokenType();
                } else {
                    return false;
                }
                return JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType);
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/opassign/PostfixPrefixIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        return IntentionPowerPackBundle.message("postfix.prefix.intention.name", PostfixPrefixIntention.getReplacementText(element));
    }

    @NotNull
    private static String getReplacementText(PsiElement element) {
        if (element instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            PsiExpression operand = prefixExpression.getOperand();
            assert (operand != null);
            PsiJavaToken sign = prefixExpression.getOperationSign();
            String string = operand.getText() + sign.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/opassign/PostfixPrefixIntention", "getReplacementText"));
            }
            return string;
        }
        PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
        PsiExpression operand = postfixExpression.getOperand();
        PsiJavaToken sign = postfixExpression.getOperationSign();
        String string = sign.getText() + operand.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/opassign/PostfixPrefixIntention", "getReplacementText"));
        }
        return string;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/opassign/PostfixPrefixIntention", "processIntention"));
        }
        PsiExpression expression = (PsiExpression)element;
        PsiReplacementUtil.replaceExpression(expression, PostfixPrefixIntention.getReplacementText(element));
    }
}

