/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.SingleConnectionNetService;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiDecoder;
import org.jetbrains.io.fastCgi.FastCgiRequest;
import org.jetbrains.io.fastCgi.FastCgiService$configureBootstrap$;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aJ\u0016\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiService;", "Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "requestIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "requests", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lio/netty/channel/Channel;", "getRequests", "()Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "allocateRequestId", "", "channel", "configureBootstrap", "", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "handleError", "fastCgiRequest", "Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "content", "Lio/netty/buffer/ByteBuf;", "responseReceived", "id", "buffer", "send", "built-in-server"})
public abstract class FastCgiService
extends SingleConnectionNetService {
    private final AtomicInteger requestIdCounter;
    @NotNull
    private final ConcurrentIntObjectMap<Channel> requests;

    @NotNull
    protected final ConcurrentIntObjectMap<Channel> getRequests() {
        return this.requests;
    }

    @Override
    protected void configureBootstrap(@NotNull Bootstrap bootstrap, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)bootstrap, (String)"bootstrap");
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap $receiver$iv = bootstrap;
        $receiver$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(this, errorOutputConsumer){
            final /* synthetic */ FastCgiService this$0;
            final /* synthetic */ Consumer $errorOutputConsumer$inlined;

            protected void initChannel(Channel channel) {
                Channel it = channel;
                it.pipeline().addLast("fastCgiDecoder", (ChannelHandler)new FastCgiDecoder((Consumer<String>)this.$errorOutputConsumer$inlined, this.this$0));
                it.pipeline().addLast("exceptionHandler", ChannelExceptionHandler.getInstance());
                ChannelFuture $receiver$iv = it.closeFuture();
                $receiver$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
                    final /* synthetic */ configureBootstrap$$inlined$handler$1 this$0;

                    public final void operationComplete(ChannelFuture it) {
                        ChannelFuture channelFuture = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                        ChannelFuture it2 = channelFuture;
                        FastCgiService.access$getRequestIdCounter$p(this.this$0.this$0).set(0);
                        if (!this.this$0.this$0.getRequests().isEmpty()) {
                            Enumeration $receiver$iv = this.this$0.this$0.getRequests().elements();
                            List list = Collections.list($receiver$iv);
                            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"Collections.list(this)");
                            List waitingClients = list;
                            this.this$0.this$0.getRequests().clear();
                            Iterator<E> iterator = waitingClients.iterator();
                            while (iterator.hasNext()) {
                                Channel channel;
                                Channel channel2 = channel = (Channel)iterator.next();
                                Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"channel");
                                FastCgiServiceKt.access$sendBadGateway(channel2);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = fastCgiService;
                this.$errorOutputConsumer$inlined = consumer;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void send(@NotNull FastCgiRequest fastCgiRequest, @NotNull ByteBuf content) {
        ByteBuf notEmptyContent;
        Intrinsics.checkParameterIsNotNull((Object)fastCgiRequest, (String)"fastCgiRequest");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (content.isReadable()) {
            content.retain();
            notEmptyContent = content;
            notEmptyContent.touch();
        } else {
            notEmptyContent = null;
        }
        try {
            void $receiver$iv;
            Promise<Channel> promise2;
            Channel channel;
            if (this.getProcessHandler().has()) {
                channel = this.getProcessChannel().get();
                if (channel != null && channel.isOpen()) {
                    fastCgiRequest.writeToServerChannel(notEmptyContent, channel);
                    return;
                }
                promise2 = this.connectAgain();
            } else {
                Promise<Channel> promise3 = this.getProcessHandler().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"processHandler.get()");
                promise2 = promise3;
            }
            channel = promise2;
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
            }
            ((Promise)v1).done(new Consumer<? super T>(this, fastCgiRequest, notEmptyContent){
                final /* synthetic */ FastCgiService this$0;
                final /* synthetic */ FastCgiRequest $fastCgiRequest$inlined;
                final /* synthetic */ ByteBuf $notEmptyContent$inlined;

                public final void consume(Object it) {
                    V v = FastCgiService.access$getProcessChannel$p(this.this$0).get();
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$fastCgiRequest$inlined.writeToServerChannel(this.$notEmptyContent$inlined, (Channel)v);
                }
                {
                    this.this$0 = fastCgiService;
                    this.$fastCgiRequest$inlined = fastCgiRequest;
                    this.$notEmptyContent$inlined = byteBuf;
                }
            }).rejected((Consumer)new Consumer<Throwable>(this, fastCgiRequest, notEmptyContent){
                final /* synthetic */ FastCgiService this$0;
                final /* synthetic */ FastCgiRequest $fastCgiRequest;
                final /* synthetic */ ByteBuf $notEmptyContent;

                public final void consume(Throwable it) {
                    Promise.logError((Logger)FastCgiServiceKt.getLOG(), (Throwable)it);
                    FastCgiService.access$handleError(this.this$0, this.$fastCgiRequest, this.$notEmptyContent);
                }
                {
                    this.this$0 = fastCgiService;
                    this.$fastCgiRequest = fastCgiRequest;
                    this.$notEmptyContent = byteBuf;
                }
            });
            return;
        }
        catch (Throwable e) {
            FastCgiServiceKt.getLOG().error(e);
            this.handleError(fastCgiRequest, notEmptyContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleError(FastCgiRequest fastCgiRequest, ByteBuf content) {
        try {
            if (content != null && content.refCnt() != 0) {
                content.release();
            }
        }
        finally {
            Channel channel = (Channel)this.requests.remove(fastCgiRequest.getRequestId());
            if (channel != null) {
                FastCgiServiceKt.access$sendBadGateway(channel);
            }
        }
    }

    public final int allocateRequestId(@NotNull Channel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        int requestId = this.requestIdCounter.getAndIncrement();
        if (requestId >= Short.MAX_VALUE) {
            this.requestIdCounter.set(0);
            requestId = this.requestIdCounter.getAndDecrement();
        }
        this.requests.put(requestId, (Object)channel);
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void responseReceived(int id, @Nullable ByteBuf buffer) {
        Channel channel = (Channel)this.requests.remove(id);
        if (channel == null || !channel.isActive()) {
            ByteBuf byteBuf = buffer;
            Boolean bl = byteBuf != null ? Boolean.valueOf(byteBuf.release()) : null;
            return;
        }
        if (buffer == null) {
            Responses.sendStatus(HttpResponseStatus.BAD_GATEWAY, channel);
            return;
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
        try {
            FastCgiServiceKt.access$parseHeaders((HttpResponse)httpResponse, buffer);
            Responses.addServer((HttpResponse)httpResponse);
            if (!HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)httpResponse))) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)httpResponse), (long)buffer.readableBytes());
            }
        }
        catch (Throwable e) {
            buffer.release();
            try {
                FastCgiServiceKt.getLOG().error(e);
            }
            finally {
                Responses.sendStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR, channel);
            }
            return;
        }
        channel.writeAndFlush((Object)httpResponse);
    }

    public FastCgiService(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.requestIdCounter = new AtomicInteger();
        ConcurrentIntObjectMap concurrentIntObjectMap = ContainerUtil.createConcurrentIntObjectMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentIntObjectMap, (String)"ContainerUtil.createConc\u2026ntIntObjectMap<Channel>()");
        this.requests = concurrentIntObjectMap;
    }

    @NotNull
    public static final /* synthetic */ AtomicInteger access$getRequestIdCounter$p(FastCgiService $this) {
        return $this.requestIdCounter;
    }

    @NotNull
    public static final /* synthetic */ AtomicReference access$getProcessChannel$p(FastCgiService $this) {
        return $this.getProcessChannel();
    }

    public static final /* synthetic */ void access$handleError(FastCgiService $this, @NotNull FastCgiRequest fastCgiRequest, @Nullable ByteBuf content) {
        $this.handleError(fastCgiRequest, content);
    }
}

