/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassQualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.types.KotlinType;

public class CodeInsightUtils {
    @Nullable
    public static KtExpression findExpression(@NotNull PsiFile file, int startOffset, int endOffset) {
        KtExpression statement2;
        List<KtExpression> statements;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findExpression"));
        }
        KtExpression element2 = CodeInsightUtils.findElementOfClassAtRange(file, startOffset, endOffset, KtExpression.class);
        if (element2 instanceof KtScriptInitializer) {
            element2 = ((KtScriptInitializer)element2).getBody();
        }
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)element2).getReferencedNameElementType() != KtTokens.IDENTIFIER && element2.getParent() instanceof KtBinaryExpression) {
            return null;
        }
        if (KtPsiUtil.isLabelIdentifierExpression((PsiElement)element2)) {
            element2 = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, KtExpression.class);
        }
        if (element2 instanceof KtBlockExpression && (statements = ((KtBlockExpression)element2).getStatements()).size() == 1 && (statement2 = statements.get(0)).getText().equals(element2.getText())) {
            return statement2;
        }
        KtExpression expression2 = element2;
        BindingContext context = ResolutionUtils.analyze(expression2);
        Qualifier qualifier2 = context.get(BindingContext.QUALIFIER, expression2);
        if (qualifier2 != null) {
            if (!(qualifier2 instanceof ClassQualifier)) {
                return null;
            }
            ClassDescriptor classifier2 = ((ClassQualifier)qualifier2).getClassifier();
            if (!(classifier2 instanceof ClassDescriptor) || classifier2.getKind() != ClassKind.OBJECT) {
                return null;
            }
        }
        return expression2;
    }

    @NotNull
    public static PsiElement[] findStatements(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
        }
        PsiElement element1 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file, startOffset);
        PsiElement element2 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file, endOffset);
        if (element1 == null || element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        startOffset = element1.getTextRange().getStartOffset();
        if (startOffset >= (endOffset = element2.getTextRange().getEndOffset())) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (!(parent2 instanceof KtBlockExpression)) {
            if (parent2 == null || parent2 instanceof KtFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
            parent2 = parent2.getParent();
        }
        if (startOffset != (element1 = CodeInsightUtils.getTopmostParentInside(element1, parent2)).getTextRange().getStartOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (endOffset != (element2 = CodeInsightUtils.getTopmostParentInside(element2, parent2)).getTextRange().getEndOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        PsiElement stopElement = element2.getNextSibling();
        for (PsiElement currentElement = element1; currentElement != stopElement; currentElement = currentElement.getNextSibling()) {
            if (currentElement instanceof PsiWhiteSpace) continue;
            array.add(currentElement);
        }
        for (PsiElement element3 : array) {
            if (element3 instanceof KtExpression || element3.getNode().getElementType() == KtTokens.SEMICOLON || element3 instanceof PsiWhiteSpace || element3 instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findStatements"));
        }
        return psiElementArray;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file, int startOffset, int endOffset, Class<T> aClass2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementOfClassAtRange"));
        }
        PsiElement element1 = CodeInsightUtils.getParentLabelOrElement(CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file, startOffset));
        PsiElement element2 = CodeInsightUtils.getParentLabelOrElement(CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file, endOffset));
        if (element1 == null || element2 == null) {
            return null;
        }
        startOffset = element1.getTextRange().getStartOffset();
        PsiElement newElement = PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)(endOffset = element2.getTextRange().getEndOffset()), aClass2);
        if (newElement == null || newElement.getTextRange().getStartOffset() != startOffset || newElement.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return (T)newElement;
    }

    private static PsiElement getParentLabelOrElement(@Nullable PsiElement element2) {
        if (element2 != null && element2.getParent() instanceof KtLabelReferenceExpression) {
            return element2.getParent();
        }
        return element2;
    }

    @NotNull
    public static List<PsiElement> findElementsOfClassInRange(@NotNull PsiFile file, int startOffset, int endOffset, Class<? extends PsiElement> ... classes2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
        }
        PsiElement element1 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceBefore(file, startOffset);
        PsiElement element2 = CodeInsightUtils.getElementAtOffsetIgnoreWhitespaceAfter(file, endOffset);
        if (element1 == null || element2 == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list2;
        }
        startOffset = element1.getTextRange().getStartOffset();
        endOffset = element2.getTextRange().getEndOffset();
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent2 == null) {
            List<PsiElement> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list3;
        }
        if (startOffset != (element1 = CodeInsightUtils.getTopmostParentInside(element1, parent2)).getTextRange().getStartOffset()) {
            List<PsiElement> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list4;
        }
        if (endOffset != (element2 = CodeInsightUtils.getTopmostParentInside(element2, parent2)).getTextRange().getEndOffset()) {
            List<PsiElement> list5 = Collections.emptyList();
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
            }
            return list5;
        }
        PsiElement stopElement = element2.getNextSibling();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement currentElement = element1; currentElement != stopElement && currentElement != null; currentElement = currentElement.getNextSibling()) {
            for (Class<? extends PsiElement> aClass2 : classes2) {
                if (aClass2.isInstance(currentElement)) {
                    result2.add(currentElement);
                }
                result2.addAll(PsiTreeUtil.findChildrenOfType((PsiElement)currentElement, aClass2));
            }
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "findElementsOfClassInRange"));
        }
        return arrayList;
    }

    @NotNull
    private static PsiElement getTopmostParentInside(@NotNull PsiElement element2, @NotNull PsiElement parent2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostParentInside"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostParentInside"));
        }
        if (!parent2.equals(element2)) {
            while (!parent2.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        PsiElement psiElement2 = element2;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostParentInside"));
        }
        return psiElement2;
    }

    @Nullable
    public static PsiElement getElementAtOffsetIgnoreWhitespaceBefore(@NotNull PsiFile file, int offset2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getElementAtOffsetIgnoreWhitespaceBefore"));
        }
        PsiElement element2 = file.findElementAt(offset2);
        if (element2 instanceof PsiWhiteSpace) {
            return file.findElementAt(element2.getTextRange().getEndOffset());
        }
        return element2;
    }

    @Nullable
    public static PsiElement getElementAtOffsetIgnoreWhitespaceAfter(@NotNull PsiFile file, int offset2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getElementAtOffsetIgnoreWhitespaceAfter"));
        }
        PsiElement element2 = file.findElementAt(offset2 - 1);
        if (element2 instanceof PsiWhiteSpace) {
            return file.findElementAt(element2.getTextRange().getStartOffset() - 1);
        }
        return element2;
    }

    @Nullable
    public static String defaultInitializer(KotlinType type2) {
        if (type2.isMarkedNullable()) {
            return "null";
        }
        if (KotlinBuiltIns.isInt(type2) || KotlinBuiltIns.isLong(type2) || KotlinBuiltIns.isShort(type2) || KotlinBuiltIns.isByte(type2)) {
            return "0";
        }
        if (KotlinBuiltIns.isFloat(type2)) {
            return "0.0f";
        }
        if (KotlinBuiltIns.isDouble(type2)) {
            return "0.0";
        }
        if (KotlinBuiltIns.isChar(type2)) {
            return "'\\u0000'";
        }
        if (KotlinBuiltIns.isBoolean(type2)) {
            return "false";
        }
        if (KotlinBuiltIns.isUnit(type2)) {
            return "Unit";
        }
        if (KotlinBuiltIns.isString(type2)) {
            return "\"\"";
        }
        return null;
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor, @NotNull String message2, @NotNull String title, @Nullable String helpId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "showErrorHint"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message2);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)title, (String)helpId);
    }

    private CodeInsightUtils() {
    }

    @Nullable
    public static Integer getStartLineOffset(@NotNull PsiFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getStartLineOffset"));
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        if (line >= document.getLineCount()) {
            return null;
        }
        int lineStartOffset = document.getLineStartOffset(line);
        return CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @Nullable
    public static Integer getEndLineOffset(@NotNull PsiFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getEndLineOffset"));
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        if (line >= document.getLineCount()) {
            return null;
        }
        int lineStartOffset = document.getLineEndOffset(line);
        return CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)lineStartOffset, (String)" \t");
    }

    @Nullable
    public static PsiElement getTopmostElementAtOffset(@NotNull PsiElement element2, int offset2) {
        PsiElement parent2;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostElementAtOffset"));
        }
        while ((parent2 = element2.getParent()) != null && parent2.getTextOffset() >= offset2 && !(parent2 instanceof KtBlockExpression)) {
            element2 = parent2;
        }
        return element2;
    }

    @Nullable
    public static <T> T getTopmostElementAtOffset(@NotNull PsiElement element2, int offset2, @NotNull Class<T> klass) {
        PsiElement parent2;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostElementAtOffset"));
        }
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils", "getTopmostElementAtOffset"));
        }
        PsiElement lastElementOfType = null;
        if (klass.isInstance(element2)) {
            lastElementOfType = element2;
        }
        while ((parent2 = element2.getParent()) != null && parent2.getTextOffset() >= offset2 && !(parent2 instanceof KtBlockExpression)) {
            if (klass.isInstance(parent2)) {
                lastElementOfType = parent2;
            }
            element2 = parent2;
        }
        return (T)lastElementOfType;
    }
}

