/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.messages.MessageBusConnection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ModuleType;
import org.jetbrains.kotlin.idea.configuration.ModuleTypeCacheKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\tR)\u0010\u0005\u001a\u001d\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ModuleTypeCacheManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedValue", "Lcom/intellij/psi/util/ParameterizedCachedValue;", "Lorg/jetbrains/kotlin/idea/configuration/ModuleType;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/annotations/NotNull;", "vfsModificationTracker", "Lorg/jetbrains/kotlin/idea/configuration/ModuleTypeCacheManager$VfsModificationTracker;", "getModuleType", "module", "isGradleModule", "", "Companion", "VfsModificationTracker", "idea-analysis"})
public final class ModuleTypeCacheManager {
    private final VfsModificationTracker vfsModificationTracker;
    private final ParameterizedCachedValue<ModuleType, Module> cachedValue;
    public static final Companion Companion = new Companion(null);

    public final boolean isGradleModule(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return Intrinsics.areEqual((Object)((Object)this.getModuleType(module)), (Object)((Object)ModuleType.GRADLE));
    }

    private final ModuleType getModuleType(Module module) {
        return (ModuleType)((Object)this.cachedValue.getValue((Object)module));
    }

    private ModuleTypeCacheManager(Project project) {
        this.vfsModificationTracker = new VfsModificationTracker(project);
        this.cachedValue = CachedValuesManager.getManager((Project)project).createParameterizedCachedValue(new ParameterizedCachedValueProvider<T, P>(this){
            final /* synthetic */ ModuleTypeCacheManager this$0;

            public final CachedValueProvider.Result<ModuleType> compute(@Nullable Module module) {
                ModuleType moduleType = module != null ? ModuleTypeCacheKt.access$computeType(module) : (ModuleType)null;
                return CachedValueProvider.Result.create((Object)((Object)moduleType), (Object[])new Object[]{ModuleTypeCacheManager.access$getVfsModificationTracker$p(this.this$0)});
            }
            {
                this.this$0 = moduleTypeCacheManager;
            }
        }, false);
    }

    @NotNull
    public static final /* synthetic */ VfsModificationTracker access$getVfsModificationTracker$p(ModuleTypeCacheManager $this) {
        return $this.vfsModificationTracker;
    }

    @JvmStatic
    public static final ModuleTypeCacheManager getInstance(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ModuleTypeCacheManager$VfsModificationTracker;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "idea-analysis"})
    private static final class VfsModificationTracker
    extends SimpleModificationTracker {
        public VfsModificationTracker(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            MessageBusConnection connection = project.getMessageBus().connect();
            connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new VirtualFileAdapter(){

                public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    this.incModificationCount();
                }

                public void fileCreated(@NotNull VirtualFileEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    this.incModificationCount();
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    this.incModificationCount();
                }

                public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    this.incModificationCount();
                }

                public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    this.incModificationCount();
                }
            }));
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ModuleTypeCacheManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/configuration/ModuleTypeCacheManager;", "kotlin.jvm.PlatformType", "project", "Lcom/intellij/openapi/project/Project;", "idea-analysis"})
    public static final class Companion {
        @JvmStatic
        public final ModuleTypeCacheManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (ModuleTypeCacheManager)ServiceManager.getService((Project)project, ModuleTypeCacheManager.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

