/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J&\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\"\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u001cH\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "argument", "(Lorg/jetbrains/kotlin/psi/KtValueArgument;)V", "addName", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "Lorg/jetbrains/kotlin/name/Name;", "calculatePossibleArgumentNames", "", "chooseNameAndAdd", "editor", "Lcom/intellij/openapi/editor/Editor;", "names", "createArgumentWithName", "getFamilyName", "", "getNamePopup", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "getText", "invoke", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Lcom/intellij/psi/PsiFile;", "Companion", "idea"})
public final class AddNameToArgumentFix
extends KotlinQuickFixAction<KtValueArgument> {
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        if (((KtValueArgument)this.getElement()).getArgumentExpression() == null) {
            return false;
        }
        Collection collection = this.calculatePossibleArgumentNames();
        return !$receiver$iv.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Unit unit;
        void $receiver$iv22;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        List<Name> possibleNames = this.calculatePossibleArgumentNames();
        Collection collection = possibleNames;
        boolean $receiver$iv22 = !$receiver$iv22.isEmpty();
        if (_Assertions.ENABLED) {
            void value$iv;
            if (value$iv == false) {
                String message$iv = "isAvailable() should be checked before invoke()";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        if (possibleNames.size() == 1 || editor == null || !editor.getComponent().isShowing()) {
            this.addName(project, (KtValueArgument)this.getElement(), (Name)CollectionsKt.first(possibleNames));
        } else {
            this.chooseNameAndAdd(project, editor, possibleNames);
        }
    }

    @NotNull
    public String getText() {
        Object object;
        block3: {
            block2: {
                object = (Name)CollectionsKt.singleOrNull(this.calculatePossibleArgumentNames());
                if (object == null) break block2;
                Name $receiver$iv = object;
                Name it = $receiver$iv;
                object = "Add name to argument: '" + this.createArgumentWithName(it).getText() + "'";
                if (object != null) break block3;
            }
            object = "Add name to argument...";
        }
        return object;
    }

    @NotNull
    public String getFamilyName() {
        return "Add name to argument";
    }

    /*
     * WARNING - void declaration
     */
    private final List<Name> calculatePossibleArgumentNames() {
        ArgumentMatch argumentMatch;
        Object object;
        ValueParameterDescriptor it;
        Collection collection;
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        KotlinType kotlinType;
        Object it2;
        void $receiver$iv2;
        Object t = this.getElement();
        boolean strict$iv = true;
        KtCallElement ktCallElement = (KtCallElement)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, KtCallElement.class, (boolean)strict$iv);
        if (ktCallElement == null) {
            return CollectionsKt.emptyList();
        }
        KtCallElement callElement2 = ktCallElement;
        BindingContext context = ResolutionUtils.analyze((KtElement)this.getElement(), BodyResolveMode.PARTIAL);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(callElement2, context);
        if (resolvedCall == null) {
            return CollectionsKt.emptyList();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = resolvedCall;
        KtExpression ktExpression = ((KtValueArgument)this.getElement()).getArgumentExpression();
        if (ktExpression != null) {
            void $receiver$iv3;
            KtExpression ktExpression2 = ktExpression;
            it2 = (KtExpression)$receiver$iv3;
            kotlinType = context.getType((KtExpression)it2);
        } else {
            kotlinType = null;
        }
        KotlinType argumentType = kotlinType;
        it2 = resolvedCall2.getCall().getValueArguments();
        void $i$a$1 = $receiver$iv;
        Collection $i$f$let = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            ValueArgument valueArgument = (ValueArgument)item$iv$iv;
            collection = destination$iv$iv;
            object = resolvedCall2.getArgumentMapping((ValueArgument)((Object)it));
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof ArgumentMatch)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            argumentMatch = (ArgumentMatch)element$iv$iv;
            if (!(argumentType == null || argumentType.isError() || !argumentMatch.isError())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            argumentMatch = (ArgumentMatch)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getValueParameter();
            collection.add(object);
        }
        Set usedParameters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $receiver$iv = resolvedCall2.getResultingDescriptor().getValueParameters();
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ValueParameterDescriptor)element$iv$iv;
            if (!(usedParameters.contains(it) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getName();
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    private final void addName(Project project, KtValueArgument argument2, Name name2) {
        ApplicationUtilsKt.executeWriteCommand(project, "Add name to argument", (Function0<Unit>)((Function0)new Function0<Unit>(this, argument2, name2){
            final /* synthetic */ AddNameToArgumentFix this$0;
            final /* synthetic */ KtValueArgument $argument;
            final /* synthetic */ Name $name;

            public final void invoke() {
                this.$argument.replace((PsiElement)AddNameToArgumentFix.access$createArgumentWithName(this.this$0, this.$name));
            }
            {
                this.this$0 = addNameToArgumentFix;
                this.$argument = ktValueArgument;
                this.$name = name2;
                super(0);
            }
        }));
    }

    private final KtValueArgument createArgumentWithName(Name name2) {
        KtExpression ktExpression = ((KtValueArgument)this.getElement()).getArgumentExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression argumentExpression = ktExpression;
        KtValueArgument newArgument = KtPsiFactoryKt.KtPsiFactory(this.getElement()).createArgument(argumentExpression, name2, ((KtValueArgument)this.getElement()).getSpreadElement() != null);
        return newArgument;
    }

    private final void chooseNameAndAdd(Project project, Editor editor, List<Name> names) {
        JBPopupFactory.getInstance().createListPopup(this.getNamePopup(project, names)).showInBestPositionFor(editor);
    }

    private final ListPopupStep<Name> getNamePopup(Project project, List<Name> names) {
        return (ListPopupStep)new BaseListPopupStep<Name>(this, project, "Choose parameter name", names){
            final /* synthetic */ AddNameToArgumentFix this$0;
            final /* synthetic */ Project $project;

            @Nullable
            public PopupStep<?> onChosen(@NotNull Name selectedValue, boolean finalChoice) {
                Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"selectedValue");
                AddNameToArgumentFix.access$addName(this.this$0, this.$project, (KtValueArgument)this.this$0.getElement(), selectedValue);
                return PopupStep.FINAL_CHOICE;
            }

            public Icon getIconFor(@NotNull Name name2) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                return KotlinIcons.PARAMETER;
            }

            public String getTextFor(@NotNull Name name2) {
                Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                return AddNameToArgumentFix.access$createArgumentWithName(this.this$0, name2).getText();
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3);
            }
        };
    }

    public AddNameToArgumentFix(@NotNull KtValueArgument argument2) {
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        super((PsiElement)argument2);
    }

    @NotNull
    public static final /* synthetic */ KtValueArgument access$createArgumentWithName(AddNameToArgumentFix $this, @NotNull Name name2) {
        return $this.createArgumentWithName(name2);
    }

    public static final /* synthetic */ void access$addName(AddNameToArgumentFix $this, @NotNull Project project, @NotNull KtValueArgument argument2, @NotNull Name name2) {
        $this.addName(project, argument2, name2);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddNameToArgumentFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            void strict$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            boolean bl = false;
            KtValueArgument ktValueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtValueArgument.class, (boolean)strict$iv);
            if (ktValueArgument == null) {
                return null;
            }
            KtValueArgument argument2 = ktValueArgument;
            return new AddNameToArgumentFix(argument2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

