/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class ChangeVariableTypeFix
extends KotlinQuickFixAction<KtVariableDeclaration> {
    private final KotlinType type;

    public ChangeVariableTypeFix(@NotNull KtVariableDeclaration element2, @NotNull KotlinType type2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "<init>"));
        }
        super(element2);
        this.type = type2;
    }

    @NotNull
    public String getText() {
        String propertyName = ((KtVariableDeclaration)this.getElement()).getName();
        FqName fqName2 = ((KtVariableDeclaration)this.getElement()).getFqName();
        if (fqName2 != null) {
            propertyName = fqName2.asString();
        }
        String string = KotlinBundle.message("change.element.type", propertyName, IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(this.type));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = KotlinBundle.message("change.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && !ErrorUtils.containsErrorType(this.type);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, @NotNull KtFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "invoke"));
        }
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)file);
        PsiElement nameIdentifier = ((KtVariableDeclaration)this.getElement()).getNameIdentifier();
        assert (nameIdentifier != null) : "ChangeVariableTypeFix applied to variable without name";
        KtTypeReference replacingTypeReference = psiFactory.createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(this.type));
        ArrayList<KtTypeReference> toShorten = new ArrayList<KtTypeReference>();
        toShorten.add(((KtVariableDeclaration)this.getElement()).setTypeReference(replacingTypeReference));
        if (this.getElement() instanceof KtProperty) {
            KtTypeReference setterParameterTypeRef;
            KtPropertyAccessor setter;
            KtTypeReference getterReturnTypeRef;
            KtPropertyAccessor getter = ((KtProperty)this.getElement()).getGetter();
            KtTypeReference ktTypeReference = getterReturnTypeRef = getter == null ? null : getter.getReturnTypeReference();
            if (getterReturnTypeRef != null) {
                toShorten.add((KtTypeReference)getterReturnTypeRef.replace((PsiElement)replacingTypeReference));
            }
            KtParameter setterParameter = (setter = ((KtProperty)this.getElement()).getSetter()) == null ? null : setter.getParameter();
            KtTypeReference ktTypeReference2 = setterParameterTypeRef = setterParameter == null ? null : setterParameter.getTypeReference();
            if (setterParameterTypeRef != null) {
                toShorten.add((KtTypeReference)setterParameterTypeRef.replace((PsiElement)replacingTypeReference));
            }
        }
        ShortenReferences.DEFAULT.process(toShorten);
    }

    @NotNull
    public static KotlinSingleIntentionActionFactory createFactoryForComponentFunctionReturnTypeMismatch() {
        KotlinSingleIntentionActionFactory kotlinSingleIntentionActionFactory = new KotlinSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$1", "createAction"));
                }
                KtDestructuringDeclarationEntry entry = ChangeFunctionReturnTypeFix.getDestructuringDeclarationEntryThatTypeMismatchComponentFunction(diagnostic);
                BindingContext context = ResolutionUtils.analyze(entry);
                ResolvedCall<FunctionDescriptor> resolvedCall = context.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                if (resolvedCall == null) {
                    return null;
                }
                KtFunction componentFunction = (KtFunction)DescriptorToSourceUtils.descriptorToDeclaration(resolvedCall.getCandidateDescriptor());
                if (componentFunction == null) {
                    return null;
                }
                KotlinType expectedType = resolvedCall.getCandidateDescriptor().getReturnType();
                return expectedType == null ? null : new ChangeVariableTypeFix(entry, expectedType);
            }
        };
        if (kotlinSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "createFactoryForComponentFunctionReturnTypeMismatch"));
        }
        return kotlinSingleIntentionActionFactory;
    }

    @NotNull
    public static KotlinIntentionActionsFactory createFactoryForPropertyOrReturnTypeMismatchOnOverride() {
        KotlinIntentionActionsFactory kotlinIntentionActionsFactory = new KotlinIntentionActionsFactory(){

            @Override
            @NotNull
            protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$2", "doCreateActions"));
                }
                LinkedList<IntentionAction> actions2 = new LinkedList<IntentionAction>();
                if (diagnostic.getPsiElement() instanceof KtProperty) {
                    PsiElement overriddenProperty;
                    KtProperty property2 = (KtProperty)diagnostic.getPsiElement();
                    DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor(property2);
                    if (!(descriptor2 instanceof PropertyDescriptor)) {
                        LinkedList<IntentionAction> linkedList = actions2;
                        if (linkedList == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$2", "doCreateActions"));
                        }
                        return linkedList;
                    }
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
                    KotlinType lowerBoundOfOverriddenPropertiesTypes = QuickFixUtil.findLowerBoundOfOverriddenCallablesReturnTypes(propertyDescriptor);
                    KotlinType propertyType = propertyDescriptor.getReturnType();
                    assert (propertyType != null) : "Property type cannot be null if it mismatch something";
                    LinkedList<PropertyDescriptor> overriddenMismatchingProperties = new LinkedList<PropertyDescriptor>();
                    boolean canChangeOverriddenPropertyType = true;
                    for (PropertyDescriptor propertyDescriptor2 : propertyDescriptor.getOverriddenDescriptors()) {
                        KotlinType overriddenPropertyType = propertyDescriptor2.getReturnType();
                        if (overriddenPropertyType == null) continue;
                        if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(propertyType, overriddenPropertyType)) {
                            overriddenMismatchingProperties.add(propertyDescriptor2);
                        } else if (propertyDescriptor2.isVar() && !KotlinTypeChecker.DEFAULT.equalTypes(overriddenPropertyType, propertyType)) {
                            canChangeOverriddenPropertyType = false;
                        }
                        if (!propertyDescriptor2.isVar() || lowerBoundOfOverriddenPropertiesTypes == null || KotlinTypeChecker.DEFAULT.equalTypes(lowerBoundOfOverriddenPropertiesTypes, overriddenPropertyType)) continue;
                        lowerBoundOfOverriddenPropertiesTypes = null;
                    }
                    if (lowerBoundOfOverriddenPropertiesTypes != null) {
                        actions2.add(new ChangeVariableTypeFix(property2, lowerBoundOfOverriddenPropertiesTypes));
                    }
                    if (overriddenMismatchingProperties.size() == 1 && canChangeOverriddenPropertyType && (overriddenProperty = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)overriddenMismatchingProperties.get(0))) instanceof KtProperty) {
                        actions2.add(new ChangeVariableTypeFix((KtProperty)overriddenProperty, propertyType));
                    }
                }
                LinkedList<IntentionAction> linkedList = actions2;
                if (linkedList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix$2", "doCreateActions"));
                }
                return linkedList;
            }
        };
        if (kotlinIntentionActionsFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeVariableTypeFix", "createFactoryForPropertyOrReturnTypeMismatchOnOverride"));
        }
        return kotlinIntentionActionsFactory;
    }
}

