/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.inline.InlineUtilKt$WhenMappings;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.Flags;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a,\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u000e"}, d2={"inlineFunctionsJvmNames", "", "", "bytes", "", "functions", "", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Function;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "protoTypeTable", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$TypeTable;", "readKotlinHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "frontend.java"})
public final class InlineUtilKt {
    @NotNull
    public static final Set<String> inlineFunctionsJvmNames(@NotNull byte[] bytes2) {
        Set<String> set;
        Intrinsics.checkParameterIsNotNull((Object)bytes2, (String)"bytes");
        KotlinClassHeader header = InlineUtilKt.readKotlinHeader(bytes2);
        String[] annotationData = header.getData();
        String[] strings = header.getStrings();
        if (annotationData == null || strings == null) {
            return SetsKt.emptySet();
        }
        switch (InlineUtilKt$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
            case 1: {
                byte[] byArray = BitEncoding.decodeBytes(annotationData);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BitEncoding.decodeBytes(annotationData)");
                ClassData classData = JvmProtoBufUtil.readClassDataFrom(byArray, strings);
                List<ProtoBuf.Function> list2 = classData.getClassProto().getFunctionList();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classData.classProto.functionList");
                NameResolver nameResolver = classData.getNameResolver();
                ProtoBuf.TypeTable typeTable = classData.getClassProto().getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"classData.classProto.typeTable");
                set = InlineUtilKt.inlineFunctionsJvmNames(list2, nameResolver, typeTable);
                break;
            }
            case 2: 
            case 3: {
                byte[] byArray = BitEncoding.decodeBytes(annotationData);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"BitEncoding.decodeBytes(annotationData)");
                PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(byArray, strings);
                List<ProtoBuf.Function> list3 = packageData.getPackageProto().getFunctionList();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"packageData.packageProto.functionList");
                NameResolver nameResolver = packageData.getNameResolver();
                ProtoBuf.TypeTable typeTable = packageData.getPackageProto().getTypeTable();
                Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"packageData.packageProto.typeTable");
                set = InlineUtilKt.inlineFunctionsJvmNames(list3, nameResolver, typeTable);
                break;
            }
            default: {
                set = SetsKt.emptySet();
            }
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> inlineFunctionsJvmNames(List<ProtoBuf.Function> functions2, NameResolver nameResolver, ProtoBuf.TypeTable protoTypeTable) {
        void destination$iv$iv;
        void $receiver$iv$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        void destination$iv$iv2;
        Object element$iv$iv2;
        Iterable $receiver$iv$iv2;
        void $receiver$iv2;
        TypeTable typeTable = new TypeTable(protoTypeTable);
        Iterable iterable = functions2;
        void var6_5 = $receiver$iv2;
        Collection collection = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            ProtoBuf.Function it = (ProtoBuf.Function)element$iv$iv2;
            if (!Flags.IS_INLINE.get(it.getFlags()).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List inlineFunctions = (List)destination$iv$iv2;
        $receiver$iv$iv2 = inlineFunctions;
        destination$iv$iv2 = $receiver$iv;
        Collection collection2 = new ArrayList();
        element$iv$iv2 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            Boolean bl;
            Object element$iv$iv3 = element$iv$iv$iv;
            ProtoBuf.Function it = (ProtoBuf.Function)element$iv$iv3;
            if (JvmProtoBufUtil.INSTANCE.getJvmMethodSignature(it, nameResolver, typeTable) != null) {
                void $receiver$iv$iv$iv2;
                void it$iv$iv = $receiver$iv$iv$iv2;
                bl = destination$iv$iv.add(it$iv$iv);
                continue;
            }
            bl = null;
        }
        List jvmNames = (List)destination$iv$iv;
        return CollectionsKt.toSet((Iterable)jvmNames);
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinClassHeader readKotlinHeader(byte[] bytes2) {
        void header;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        FileBasedKotlinClass.create(bytes2, (Function3)new Function3((Ref.ObjectRef)header){
            final /* synthetic */ Ref.ObjectRef $header;

            @Nullable
            public final Void invoke(ClassId className, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
                this.$header.element = classHeader;
                return null;
            }
            {
                this.$header = objectRef;
                super(3);
            }
        });
        if ((KotlinClassHeader)header.element == null) {
            throw (Throwable)((Object)new AssertionError((Object)"Could not read kotlin header from byte array"));
        }
        KotlinClassHeader kotlinClassHeader = (KotlinClassHeader)header.element;
        if (kotlinClassHeader == null) {
            Intrinsics.throwNpe();
        }
        return kotlinClassHeader;
    }
}

