/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"checkNotEnumEntry", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkTypeReferences", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "frontend"})
public final class DeclarationsCheckerKt {
    public static final void checkTypeReferences(KtDeclaration $receiver, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        if ($receiver instanceof KtCallableDeclaration) {
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)$receiver).getTypeReference();
            Boolean bl = ktTypeReference != null ? Boolean.valueOf(DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference, trace)) : null;
            KtTypeReference ktTypeReference2 = ((KtCallableDeclaration)$receiver).getReceiverTypeReference();
            Boolean bl2 = ktTypeReference2 != null ? Boolean.valueOf(DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference2, trace)) : null;
        }
        if ($receiver instanceof KtDeclarationWithBody) {
            for (KtParameter parameter : ((KtDeclarationWithBody)$receiver).getValueParameters()) {
                KtTypeReference ktTypeReference = parameter.getTypeReference();
                Boolean bl = ktTypeReference != null ? Boolean.valueOf(DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference, trace)) : null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean checkNotEnumEntry(KtTypeReference $receiver, @NotNull BindingTrace trace) {
        void result2;
        Unit unit;
        Unit unit2;
        Object it;
        Object $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        KotlinType kotlinType = (KotlinType)trace.getBindingContext().get(BindingContext.TYPE, $receiver);
        if (kotlinType != null) {
            $receiver$iv = kotlinType;
            it = $receiver$iv;
            ClassDescriptor targetDescriptor = TypeUtils.getClassDescriptor((KotlinType)it);
            if (targetDescriptor != null && DescriptorUtils.isEnumEntry(targetDescriptor)) {
                trace.report(Errors.ENUM_ENTRY_AS_TYPE.on((KtTypeReference)((PsiElement)$receiver)));
                result2.element = true;
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        KtTypeElement ktTypeElement = $receiver.getTypeElement();
        if (ktTypeElement != null) {
            $receiver$iv = ktTypeElement;
            it = (KtTypeElement)$receiver$iv;
            Iterator<KtTypeReference> iterator2 = it.getTypeArgumentsAsTypes().iterator();
            while (iterator2.hasNext()) {
                KtTypeReference typeArgument;
                KtTypeReference ktTypeReference = typeArgument = iterator2.next();
                Boolean bl = ktTypeReference != null ? Boolean.valueOf(DeclarationsCheckerKt.checkNotEnumEntry(ktTypeReference, trace)) : null;
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return result2.element;
    }
}

