/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.groovy.GroovyBuilderExtension;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class GriffonBuilderExtension
implements GroovyBuilderExtension {
    @Override
    @NotNull
    public Collection<String> getCompilationClassPath(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/groovy/GriffonBuilderExtension", "getCompilationClassPath"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jps/incremental/groovy/GriffonBuilderExtension", "getCompilationClassPath"));
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GriffonBuilderExtension", "getCompilationClassPath"));
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<String> getCompilationUnitPatchers(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/incremental/groovy/GriffonBuilderExtension", "getCompilationUnitPatchers"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jps/incremental/groovy/GriffonBuilderExtension", "getCompilationUnitPatchers"));
        }
        for (JpsModule module : chunk.getModules()) {
            if (!GriffonBuilderExtension.shouldInjectGriffon(module)) continue;
            Set<String> set = Collections.singleton("org.jetbrains.groovy.compiler.rt.GriffonInjector");
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GriffonBuilderExtension", "getCompilationUnitPatchers"));
            }
            return set;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GriffonBuilderExtension", "getCompilationUnitPatchers"));
        }
        return list;
    }

    private static boolean shouldInjectGriffon(JpsModule module) {
        for (String rootUrl : module.getContentRootsList().getUrls()) {
            File root = JpsPathUtil.urlToFile((String)rootUrl);
            if (!new File(root, "griffon-app").isDirectory() || !new File(root, "application.properties").isFile()) continue;
            return true;
        }
        return false;
    }
}

