/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.generator;

import com.intellij.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import org.jetbrains.idea.devkit.dom.generator.FileManager;
import org.jetbrains.idea.devkit.dom.generator.Util;

public class MergingFileManager
implements FileManager {
    @Override
    public File getOutputFile(File target) {
        File outFile = target;
        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
            Util.logerr("parent mkdirs failed: " + outFile);
            return null;
        }
        int i = 0;
        while (outFile.exists()) {
            outFile = new File(target.getParentFile(), target.getName() + ".tmp." + i);
            ++i;
        }
        return outFile;
    }

    @Override
    public File releaseOutputFile(File outFile) {
        int idx = outFile.getName().indexOf(".tmp.");
        File target = outFile;
        if (idx > -1) {
            String[] prevLines;
            target = new File(outFile.getParentFile(), outFile.getName().substring(0, idx));
            String[] curLines = MergingFileManager.loadFile(outFile);
            String[] mergedLines = MergingFileManager.mergeLines(curLines, prevLines = MergingFileManager.loadFile(target));
            if (mergedLines != prevLines) {
                if (mergedLines == curLines) {
                    if (target.exists() && !target.delete()) {
                        Util.logerr("file replace failed: " + target);
                        outFile.delete();
                    } else {
                        outFile.renameTo(target);
                        Util.logwarn("file replaced: " + target);
                    }
                } else {
                    outFile.delete();
                    if (target.exists() && !target.delete()) {
                        Util.logerr("file replace failed: " + target);
                    } else {
                        MergingFileManager.writeFile(target, mergedLines);
                        Util.logwarn("file merged: " + target);
                    }
                }
            } else {
                outFile.delete();
            }
        }
        return target;
    }

    private static String[] mergeLines(String[] curLines, String[] prevLines) {
        String[] mergedLines;
        if (prevLines.length == 0) {
            return curLines;
        }
        ArrayList<String> merged = new ArrayList<String>();
        int curIdx = 0;
        int prevIdx = 0;
        boolean classScope = false;
        boolean importMerged = false;
        for (int i = 0; i < Math.max(curLines.length, prevLines.length); ++i) {
            String prev;
            String cur = curIdx < curLines.length ? curLines[curIdx] : "";
            String string = prev = prevIdx < prevLines.length ? prevLines[prevIdx] : "";
            if (classScope) {
                merged.addAll(Arrays.asList(curLines).subList(curIdx, curLines.length));
                break;
            }
            if (prev.trim().startsWith("import ") || cur.trim().startsWith("import ")) {
                if (importMerged) continue;
                importMerged = true;
                int[] indices = new int[]{curIdx, prevIdx};
                MergingFileManager.mergeImports(merged, curLines, prevLines, indices);
                curIdx = indices[0];
                prevIdx = indices[1];
                continue;
            }
            if (cur.equals(prev)) {
                if (cur.trim().startsWith("public interface ") || cur.trim().startsWith("public enum ")) {
                    classScope = true;
                }
                merged.add(cur);
                ++curIdx;
                ++prevIdx;
                continue;
            }
            if (prev.trim().startsWith("@")) {
                merged.add(prev);
                ++prevIdx;
                continue;
            }
            if (cur.trim().startsWith("@")) {
                merged.add(cur);
                ++curIdx;
                continue;
            }
            if (cur.trim().startsWith("package  ") && prev.trim().startsWith("package ")) {
                merged.add(prev);
                ++curIdx;
                ++prevIdx;
                continue;
            }
            if (cur.trim().startsWith("public interface ") && prev.trim().startsWith("public interface ")) {
                classScope = true;
                prevIdx = MergingFileManager.addAllStringsUpTo(merged, prevLines, prevIdx, "{");
                curIdx = MergingFileManager.addAllStringsUpTo(null, curLines, curIdx, "{");
                continue;
            }
            if (cur.trim().startsWith("* ")) {
                curIdx = MergingFileManager.addAllStringsUpTo(merged, curLines, curIdx, "*/");
                if (!prev.trim().startsWith("* ") && !prev.trim().endsWith("*/")) continue;
                prevIdx = MergingFileManager.addAllStringsUpTo(null, prevLines, prevIdx, "*/");
                continue;
            }
            merged.add(cur);
            ++curIdx;
            ++prevIdx;
        }
        if (MergingFileManager.compareLines(mergedLines = ArrayUtil.toStringArray(merged), prevLines, 2) == 0) {
            return prevLines;
        }
        if (MergingFileManager.compareLines(mergedLines, curLines, 2) == 0) {
            return curLines;
        }
        return mergedLines;
    }

    private static void mergeImports(ArrayList<String> merged, String[] curLines, String[] prevLines, int[] indices) {
        String name;
        String line;
        int i;
        TreeSet<String> externalClasses = new TreeSet<String>();
        for (i = 0; i < curLines.length; ++i) {
            line = curLines[i].trim();
            if (!line.startsWith("import ") || !line.endsWith(";")) continue;
            indices[0] = i + 1;
            name = line.substring("import ".length(), line.length() - 1).trim();
            if (name.endsWith("*")) continue;
            externalClasses.add(name);
        }
        for (i = 0; i < prevLines.length; ++i) {
            line = prevLines[i].trim();
            if (!line.startsWith("import ") || !line.endsWith(";")) continue;
            indices[1] = i + 1;
            name = line.substring("import ".length(), line.length() - 1).trim();
            if (name.endsWith("*")) continue;
            externalClasses.add(name);
        }
        boolean javaLang = false;
        for (String s : externalClasses) {
            if (s.startsWith("java.")) {
                javaLang = true;
                continue;
            }
            merged.add("import " + s + ";");
        }
        if (javaLang) {
            merged.add("");
            for (String s : externalClasses) {
                if (!s.startsWith("java.")) continue;
                merged.add("import " + s + ";");
            }
        }
    }

    private static int addAllStringsUpTo(ArrayList<String> merged, String[] lines, int startIdx, String upTo) {
        String str;
        do {
            String string = str = startIdx < lines.length ? lines[startIdx] : upTo;
            if (merged == null) continue;
            merged.add(str);
        } while (!str.trim().endsWith(upTo) && ++startIdx < lines.length);
        return startIdx;
    }

    private static int compareLines(String[] mergedLines, String[] curLines, int start) {
        if (mergedLines.length < curLines.length) {
            return -1;
        }
        if (mergedLines.length > curLines.length) {
            return 1;
        }
        for (int i = start; i < mergedLines.length; ++i) {
            int comp = mergedLines[i].compareTo(curLines[i]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File target, String[] mergedLines) {
        PrintWriter out = null;
        try {
            int lineCount;
            for (lineCount = mergedLines.length; lineCount > 0 && mergedLines[lineCount - 1].length() == 0; --lineCount) {
            }
            out = new PrintWriter(new FileWriter(target));
            for (int i = 0; i < lineCount; ++i) {
                String mergedLine = mergedLines[i];
                out.println(mergedLine);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] loadFile(File f1) {
        if (!f1.exists()) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(f1));
            while ((str = in.readLine()) != null) {
                list.add(str);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ArrayUtil.toStringArray(list);
    }
}

