/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.script.ImportInfo;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterFactory;
import org.apache.batik.util.Service;
import org.w3c.dom.Document;

public class InterpreterPool {
    public static final String BIND_NAME_DOCUMENT = "document";
    protected static Map defaultFactories = new HashMap(7);
    protected Map factories = new HashMap(7);

    public InterpreterPool() {
        this.factories.putAll(defaultFactories);
    }

    public Interpreter createInterpreter(Document document, String string) {
        return this.createInterpreter(document, string, null);
    }

    public Interpreter createInterpreter(Document document, String string, ImportInfo importInfo) {
        InterpreterFactory interpreterFactory = (InterpreterFactory)this.factories.get(string);
        if (interpreterFactory == null) {
            return null;
        }
        if (importInfo == null) {
            importInfo = ImportInfo.getImports();
        }
        Interpreter interpreter = null;
        SVGOMDocument sVGOMDocument = (SVGOMDocument)document;
        URL uRL = null;
        try {
            uRL = new URL(sVGOMDocument.getDocumentURI());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        interpreter = interpreterFactory.createInterpreter(uRL, sVGOMDocument.isSVG12(), importInfo);
        if (interpreter == null) {
            return null;
        }
        if (document != null) {
            interpreter.bindObject(BIND_NAME_DOCUMENT, document);
        }
        return interpreter;
    }

    public void putInterpreterFactory(String string, InterpreterFactory interpreterFactory) {
        this.factories.put(string, interpreterFactory);
    }

    public void removeInterpreterFactory(String string) {
        this.factories.remove(string);
    }

    static {
        Iterator iterator = Service.providers(InterpreterFactory.class);
        while (iterator.hasNext()) {
            InterpreterFactory interpreterFactory = null;
            interpreterFactory = (InterpreterFactory)iterator.next();
            String[] stringArray = interpreterFactory.getMimeTypes();
            for (int i = 0; i < stringArray.length; ++i) {
                defaultFactories.put(stringArray[i], interpreterFactory);
            }
        }
    }
}

