/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import junit.framework.TestCase;
import org.languagetool.AnalyzedToken;

public class AnalyzedTokenTest
extends TestCase {
    public void testToString() {
        AnalyzedToken testToken = new AnalyzedToken("word", "POS", "lemma");
        AnalyzedTokenTest.assertEquals((String)"lemma/POS", (String)testToken.toString());
        AnalyzedTokenTest.assertEquals((String)"lemma", (String)testToken.getLemma());
        AnalyzedToken testToken2 = new AnalyzedToken("word", "POS", null);
        AnalyzedTokenTest.assertEquals((String)"word/POS", (String)testToken2.toString());
        AnalyzedTokenTest.assertEquals(null, (String)testToken2.getLemma());
        AnalyzedTokenTest.assertEquals((String)"word", (String)testToken2.getToken());
    }

    public void testMatches() {
        AnalyzedToken testToken1 = new AnalyzedToken("word", "POS", "lemma");
        AnalyzedTokenTest.assertFalse((boolean)testToken1.matches(new AnalyzedToken("", null, null)));
        AnalyzedTokenTest.assertTrue((boolean)testToken1.matches(new AnalyzedToken("word", null, null)));
        AnalyzedTokenTest.assertTrue((boolean)testToken1.matches(new AnalyzedToken("word", "POS", null)));
        AnalyzedTokenTest.assertTrue((boolean)testToken1.matches(new AnalyzedToken("word", "POS", "lemma")));
        AnalyzedTokenTest.assertFalse((boolean)testToken1.matches(new AnalyzedToken("word", "POS1", "lemma")));
        AnalyzedTokenTest.assertFalse((boolean)testToken1.matches(new AnalyzedToken("word1", "POS", "lemma")));
        AnalyzedTokenTest.assertFalse((boolean)testToken1.matches(new AnalyzedToken("word", "POS", "lemma1")));
        AnalyzedTokenTest.assertTrue((boolean)testToken1.matches(new AnalyzedToken("", "POS", "lemma")));
        AnalyzedTokenTest.assertTrue((boolean)testToken1.matches(new AnalyzedToken("", null, "lemma")));
    }
}

