/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.languagemodel.BaseLanguageModel;
import org.languagetool.rules.ngrams.Probability;

public class BaseLanguageModelTest {
    @Test
    public void testPseudoProbability() throws IOException {
        try (FakeLanguageModel lm = new FakeLanguageModel();){
            Probability prob1 = lm.getPseudoProbability(Arrays.asList("no", "data", "here"));
            double delta = 0.001;
            Assert.assertEquals((double)0.01, (double)prob1.getProb(), (double)delta);
            Assert.assertThat((Object)Float.valueOf(prob1.getCoverage()), (Matcher)Is.is((Object)Float.valueOf(0.0f)));
            Probability prob2 = lm.getPseudoProbability(Arrays.asList("1", "2", "3", "4"));
            Assert.assertEquals((double)0.01, (double)prob2.getProb(), (double)delta);
            Assert.assertThat((Object)Float.valueOf(prob2.getCoverage()), (Matcher)Is.is((Object)Float.valueOf(0.0f)));
            Probability prob3 = lm.getPseudoProbability(Arrays.asList("There", "are"));
            Assert.assertEquals((double)0.119, (double)prob3.getProb(), (double)delta);
            Assert.assertThat((Object)Float.valueOf(prob3.getCoverage()), (Matcher)Is.is((Object)Float.valueOf(0.5f)));
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testPseudoProbabilityFail1() throws IOException {
        try (FakeLanguageModel lm = new FakeLanguageModel();){
            lm.getPseudoProbability(Collections.emptyList());
        }
    }

    static class FakeLanguageModel
    extends BaseLanguageModel {
        static Map<String, Integer> map = new HashMap<String, Integer>();

        FakeLanguageModel() {
            map.put("There are", 10);
            map.put("There are new", 5);
            map.put("Their are", 2);
            map.put("Their are new", 1);
            map.put("Why is", 50);
            map.put("Why is there", 5);
            map.put("Why is their", 5);
            map.put("their car", 11);
            map.put("their car broken", 2);
        }

        public long getCount(List<String> tokens) {
            Integer count = map.get(String.join((CharSequence)" ", tokens));
            return count == null ? 0L : (long)count.intValue();
        }

        public long getCount(String token1) {
            return this.getCount(Arrays.asList(token1));
        }

        public long getTotalTokenCount() {
            int sum = 0;
            for (int val : map.values()) {
                sum += val;
            }
            return sum;
        }

        public void close() {
        }
    }
}

