/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.tools.FSABuildTool;
import morfologik.tools.Launcher;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;

@Deprecated
class DictionaryBuilder {
    private final Properties props = new Properties();
    private static final int FREQ_RANGES_IN = 256;
    private static final int FREQ_RANGES_OUT = 26;
    private static final int FIRST_RANGE_CODE = 65;
    private final Map<String, Integer> freqList = new HashMap<String, Integer>();
    private final Pattern pFreqEntry = Pattern.compile(".*<w f=\"(\\d+)\" flags=\"(.*)\">(.+)</w>.*");
    private final Pattern pTaggerEntry = Pattern.compile("^([^\t]+).*$");
    private String outputFilename;

    protected DictionaryBuilder(File infoFile) throws IOException {
        this.props.load(new FileInputStream(infoFile));
    }

    protected void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    protected static void checkUsageOrExit(String className, String[] args) throws IOException {
        File dictFile;
        if (args.length < 2 || args.length > 3) {
            System.out.println("Usage: " + className + " <dictionary> <infoFile> [frequencyList]");
            System.out.println("   <dictionary> is a plain text dictionary file");
            System.out.println("   <infoFile> is the *.info properties file, see http://wiki.languagetool.org/developing-a-tagger-dictionary");
            System.out.println("   [frequencyList] is the *.xml file with a frequency wordlist, see http://wiki.languagetool.org/developing-a-tagger-dictionary");
            System.exit(1);
        }
        if (!(dictFile = new File(args[0])).exists()) {
            throw new IOException("File does not exist: " + dictFile);
        }
    }

    protected List<String> getTab2MorphOptions(File dictFile, File outputFile) throws IOException {
        ArrayList<String> tab2morphOptions = new ArrayList<String>();
        String separator = this.getOption("fsa.dict.separator");
        if (separator != null && !separator.trim().isEmpty()) {
            tab2morphOptions.add("--annotation");
            tab2morphOptions.add(separator);
        }
        if ((this.isOptionTrue("fsa.dict.uses-prefixes") || this.isOptionTrue("fsa.dict.uses-infixes")) && this.hasOption("fsa.dict.encoder")) {
            throw new IOException(".info file must specify either fsa.dict.encoder (preferred) or fsa.dict.uses-* properties.");
        }
        if (this.hasOption("fsa.dict.encoder")) {
            tab2morphOptions.add("--encoder");
            tab2morphOptions.add(this.getOption("fsa.dict.encoder"));
        } else if (this.isOptionTrue("fsa.dict.uses-prefixes")) {
            tab2morphOptions.add("--encoder");
            tab2morphOptions.add("prefix");
        } else if (this.isOptionTrue("fsa.dict.uses-infixes")) {
            tab2morphOptions.add("--encoder");
            tab2morphOptions.add("infix");
        }
        tab2morphOptions.add("-i");
        tab2morphOptions.add(dictFile.getAbsolutePath());
        tab2morphOptions.add("-o");
        tab2morphOptions.add(outputFile.getAbsolutePath());
        return tab2morphOptions;
    }

    protected void prepare(List<String> tab2morphOptions) throws Exception {
        System.out.println("Running Morfologik Launcher.main with these options: " + tab2morphOptions);
        Launcher.main(tab2morphOptions.toArray(new String[tab2morphOptions.size()]));
    }

    protected File buildDict(File tempFile) throws Exception {
        return this.buildDict(tempFile, null);
    }

    protected File buildDict(File tempFile, Language language) throws Exception {
        String suffix = language != null ? "-" + language.getShortNameWithCountryAndVariant() + ".dict" : ".dict";
        File resultFile = this.outputFilename != null ? new File(this.outputFilename) : File.createTempFile(DictionaryBuilder.class.getSimpleName(), suffix);
        System.err.println("WARNING: You are running deprecated version of dictionary builder, please use classes org.languagetool.tools");
        Object[] buildToolOptions = new String[]{"-f", "cfsa2", "-i", tempFile.getAbsolutePath(), "-o", resultFile.getAbsolutePath()};
        System.out.println("Running Morfologik FSABuildTool.main with these options: " + Arrays.toString(buildToolOptions));
        FSABuildTool.main((String[])buildToolOptions);
        System.out.println("Done. The binary dictionary has been written to " + resultFile.getAbsolutePath());
        return resultFile;
    }

    @Nullable
    protected String getOption(String option) {
        String property = this.props.getProperty(option);
        if (property == null) {
            return null;
        }
        return property.trim();
    }

    protected boolean hasOption(String option) {
        return this.props.getProperty(option) != null;
    }

    private boolean isOptionTrue(String option) {
        return this.hasOption(option) && "true".equals(this.getOption(option));
    }

    protected void readFreqList(File freqListFile) {
        try (FileInputStream fis = new FileInputStream(freqListFile.getAbsoluteFile());
             InputStreamReader reader = new InputStreamReader((InputStream)fis, "utf-8");
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m = this.pFreqEntry.matcher(line);
                if (!m.matches()) continue;
                this.freqList.put(m.group(3), Integer.parseInt(m.group(1)));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file: " + freqListFile.getAbsolutePath());
        }
    }

    protected File addFreqData(File dictFile) throws IOException {
        if (!this.isOptionTrue("fsa.dict.frequency-included")) {
            throw new IOException("In order to use frequency data add the line 'fsa.dict.frequency-included=true' to the dictionary info file.");
        }
        String separator = this.getOption("fsa.dict.separator");
        if (separator == null || separator.trim().isEmpty()) {
            throw new IOException("A separator character (fsa.dict.separator) must be defined in the dictionary info file.");
        }
        File tempFile = File.createTempFile(DictionaryBuilder.class.getSimpleName(), "WithFrequencies.txt");
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.getAbsoluteFile()), this.getOption("fsa.dict.encoding")));
        int freqValuesApplied = 0;
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dictFile.getAbsoluteFile()), this.getOption("fsa.dict.encoding")));
            int maxFreq = Collections.max(this.freqList.values());
            double maxFreqLog = Math.log(maxFreq);
            while ((line = br.readLine()) != null) {
                Matcher m = this.pTaggerEntry.matcher(line);
                if (!m.matches()) continue;
                int freq = 0;
                String key = m.group(1);
                if (this.freqList.containsKey(key)) {
                    freq = this.freqList.get(key);
                    ++freqValuesApplied;
                }
                int normalizedFreq = freq;
                if (freq > 0 && maxFreq > 255) {
                    double freqZeroToOne = Math.log(freq) / maxFreqLog;
                    normalizedFreq = (int)(freqZeroToOne * 255.0);
                }
                if (normalizedFreq < 0 || normalizedFreq > 255) {
                    throw new RuntimeException("Frequency out of range (0-255): " + normalizedFreq + " in word " + key);
                }
                String freqChar = Character.toString((char)(65 + normalizedFreq * 26 / 256));
                bw.write(line + separator + freqChar + "\n");
            }
            br.close();
            bw.close();
            System.out.println(this.freqList.size() + " frequency values applied in " + freqValuesApplied + " word forms.");
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file: " + dictFile.getAbsolutePath());
        }
        tempFile.deleteOnExit();
        return tempFile;
    }
}

